/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.block.entity.MantleHangingSignBlockEntity;
import slimeknights.mantle.block.entity.MantleSignBlockEntity;
import slimeknights.mantle.client.ClientEvents;
import slimeknights.mantle.command.MantleCommand;
import slimeknights.mantle.command.argument.ResourceOrTagKeyArgument;
import slimeknights.mantle.config.Config;
import slimeknights.mantle.data.predicate.block.BlockPredicate;
import slimeknights.mantle.data.predicate.block.BlockPropertiesPredicate;
import slimeknights.mantle.data.predicate.damage.DamageSourcePredicate;
import slimeknights.mantle.data.predicate.damage.DamageTypePredicate;
import slimeknights.mantle.data.predicate.damage.SourceAttackerPredicate;
import slimeknights.mantle.data.predicate.damage.SourceMessagePredicate;
import slimeknights.mantle.data.predicate.entity.BlockAtEntityPredicate;
import slimeknights.mantle.data.predicate.entity.HasEnchantmentEntityPredicate;
import slimeknights.mantle.data.predicate.entity.HasMobEffectPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.mantle.data.predicate.entity.MobTypePredicate;
import slimeknights.mantle.data.predicate.fluid.FluidPredicate;
import slimeknights.mantle.data.predicate.fluid.FluidTypePredicate;
import slimeknights.mantle.data.predicate.item.ItemPredicate;
import slimeknights.mantle.datagen.MantleBlockTagProvider;
import slimeknights.mantle.datagen.MantleFluidTagProvider;
import slimeknights.mantle.datagen.MantleFluidTooltipProvider;
import slimeknights.mantle.datagen.MantleFluidTransferProvider;
import slimeknights.mantle.datagen.MantleMenuTagProvider;
import slimeknights.mantle.datagen.MantleTags;
import slimeknights.mantle.fluid.transfer.EmptyFluidContainerTransfer;
import slimeknights.mantle.fluid.transfer.EmptyFluidWithNBTTransfer;
import slimeknights.mantle.fluid.transfer.EmptyPotionTransfer;
import slimeknights.mantle.fluid.transfer.FillFluidContainerTransfer;
import slimeknights.mantle.fluid.transfer.FillFluidWithNBTTransfer;
import slimeknights.mantle.fluid.transfer.FluidContainerTransferManager;
import slimeknights.mantle.item.LecternBookItem;
import slimeknights.mantle.loot.LootTableInjector;
import slimeknights.mantle.loot.MantleLoot;
import slimeknights.mantle.network.MantleNetwork;
import slimeknights.mantle.recipe.MantleRecipes;
import slimeknights.mantle.recipe.condition.TagCombinationCondition;
import slimeknights.mantle.recipe.condition.TagEmptyCondition;
import slimeknights.mantle.recipe.condition.TagFilledCondition;
import slimeknights.mantle.recipe.helper.TagPreference;
import slimeknights.mantle.recipe.ingredient.FluidContainerIngredient;
import slimeknights.mantle.recipe.ingredient.PotionDisplayIngredient;
import slimeknights.mantle.recipe.ingredient.PotionIngredient;
import slimeknights.mantle.registration.RegistrationHelper;
import slimeknights.mantle.registration.adapter.BlockEntityTypeRegistryAdapter;
import slimeknights.mantle.util.OffhandCooldownTracker;

@Mod(value="mantle")
public class Mantle {
    public static final String modId = "mantle";
    public static final Logger logger = LogManager.getLogger((String)"Mantle");
    public static final String COMMON = "forge";
    public static Mantle instance;

    public Mantle() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_SPEC);
        FluidContainerTransferManager.INSTANCE.init();
        MantleTags.init();
        instance = this;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(EventPriority.NORMAL, false, FMLCommonSetupEvent.class, this::commonSetup);
        bus.addListener(EventPriority.NORMAL, false, RegisterCapabilitiesEvent.class, this::registerCapabilities);
        bus.addListener(EventPriority.NORMAL, false, GatherDataEvent.class, this::gatherData);
        bus.addListener(EventPriority.NORMAL, false, RegisterEvent.class, this::register);
        MantleRecipes.init(bus);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, PlayerInteractEvent.RightClickBlock.class, LecternBookItem::interactWithBlock);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientEvents.onConstruct();
        }
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        OffhandCooldownTracker.register(event);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        MantleNetwork.registerPackets();
        MantleCommand.init();
        OffhandCooldownTracker.init();
        TagPreference.init();
        LootTableInjector.init();
    }

    private void register(RegisterEvent event) {
        ResourceKey key = event.getRegistryKey();
        if (key == Registries.f_256764_) {
            CraftingHelper.register(TagEmptyCondition.SERIALIZER);
            CraftingHelper.register(TagFilledCondition.SERIALIZER);
            CraftingHelper.register(TagCombinationCondition.SERIALIZER);
            CraftingHelper.register((ResourceLocation)FluidContainerIngredient.ID, (IIngredientSerializer)FluidContainerIngredient.SERIALIZER);
            CraftingHelper.register((ResourceLocation)Mantle.getResource("potion"), PotionIngredient.SERIALIZER);
            CraftingHelper.register((ResourceLocation)Mantle.getResource("potion_display"), PotionDisplayIngredient.SERIALIZER);
            FluidContainerTransferManager.TRANSFER_LOADERS.registerDeserializer(EmptyFluidContainerTransfer.ID, EmptyFluidContainerTransfer.DESERIALIZER);
            FluidContainerTransferManager.TRANSFER_LOADERS.registerDeserializer(FillFluidContainerTransfer.ID, FillFluidContainerTransfer.DESERIALIZER);
            FluidContainerTransferManager.TRANSFER_LOADERS.registerDeserializer(EmptyFluidWithNBTTransfer.ID, EmptyFluidWithNBTTransfer.DESERIALIZER);
            FluidContainerTransferManager.TRANSFER_LOADERS.registerDeserializer(FillFluidWithNBTTransfer.ID, FillFluidWithNBTTransfer.DESERIALIZER);
            FluidContainerTransferManager.TRANSFER_LOADERS.registerDeserializer(EmptyPotionTransfer.ID, EmptyPotionTransfer.DESERIALIZER);
            BlockPredicate.LOADER.register(Mantle.getResource("requires_tool"), BlockPredicate.REQUIRES_TOOL.getLoader());
            BlockPredicate.LOADER.register(Mantle.getResource("blocks_motion"), BlockPredicate.BLOCKS_MOTION.getLoader());
            BlockPredicate.LOADER.register(Mantle.getResource("can_be_replaced"), BlockPredicate.CAN_BE_REPLACED.getLoader());
            BlockPredicate.LOADER.register(Mantle.getResource("block_properties"), BlockPropertiesPredicate.LOADER);
            ItemPredicate.LOADER.register(Mantle.getResource("has_container"), ItemPredicate.HAS_CONTAINER.getLoader());
            ItemPredicate.LOADER.register(Mantle.getResource("may_have_transfer"), ItemPredicate.MAY_HAVE_TRANSFER.getLoader());
            FluidPredicate.LOADER.register(Mantle.getResource("fluid_type"), FluidTypePredicate.LOADER);
            FluidPredicate.LOADER.register(Mantle.getResource("is_source"), FluidPredicate.SOURCE.getLoader());
            FluidPredicate.LOADER.register(Mantle.getResource("has_bucket"), FluidPredicate.HAS_BUCKET.getLoader());
            FluidPredicate.LOADER.register(Mantle.getResource("lighter_than_air"), FluidPredicate.LIGHTER_THAN_AIR.getLoader());
            LivingEntityPredicate.LOADER.register(Mantle.getResource("fire_immune"), LivingEntityPredicate.FIRE_IMMUNE.getLoader());
            LivingEntityPredicate.LOADER.register(Mantle.getResource("can_freeze"), LivingEntityPredicate.CAN_FREEZE.getLoader());
            LivingEntityPredicate.LOADER.register(Mantle.getResource("water_sensitive"), LivingEntityPredicate.WATER_SENSITIVE.getLoader());
            LivingEntityPredicate.LOADER.register(Mantle.getResource("on_fire"), LivingEntityPredicate.ON_FIRE.getLoader());
            LivingEntityPredicate.LOADER.register(Mantle.getResource("is_freezing"), LivingEntityPredicate.IS_FREEZING.getLoader());
            LivingEntityPredicate.LOADER.register(Mantle.getResource("is_in_powdered_snow"), LivingEntityPredicate.IS_IN_POWDERED_SNOW.getLoader());
            LivingEntityPredicate.LOADER.register(Mantle.getResource("on_ground"), LivingEntityPredicate.ON_GROUND.getLoader());
            LivingEntityPredicate.LOADER.register(Mantle.getResource("crouching"), LivingEntityPredicate.CROUCHING.getLoader());
            LivingEntityPredicate.LOADER.register(Mantle.getResource("sprinting"), LivingEntityPredicate.SPRINTING.getLoader());
            LivingEntityPredicate.LOADER.register(Mantle.getResource("blocking"), LivingEntityPredicate.BLOCKING.getLoader());
            LivingEntityPredicate.LOADER.register(Mantle.getResource("elytra_flying"), LivingEntityPredicate.ELYTRA_FLYING.getLoader());
            LivingEntityPredicate.LOADER.register(Mantle.getResource("has_effect"), HasMobEffectPredicate.LOADER);
            LivingEntityPredicate.LOADER.register(Mantle.getResource("block_at_entity"), BlockAtEntityPredicate.LOADER);
            LivingEntityPredicate.LOADER.register(Mantle.getResource("eyes_in_water"), LivingEntityPredicate.EYES_IN_WATER.getLoader());
            LivingEntityPredicate.LOADER.register(Mantle.getResource("feet_in_water"), LivingEntityPredicate.FEET_IN_WATER.getLoader());
            LivingEntityPredicate.LOADER.register(Mantle.getResource("underwater"), LivingEntityPredicate.UNDERWATER.getLoader());
            LivingEntityPredicate.LOADER.register(Mantle.getResource("raining_at"), LivingEntityPredicate.RAINING.getLoader());
            LivingEntityPredicate.LOADER.register(Mantle.getResource("mob_type"), MobTypePredicate.LOADER);
            LivingEntityPredicate.LOADER.register(Mantle.getResource("has_enchantment"), HasEnchantmentEntityPredicate.LOADER);
            MobTypePredicate.MOB_TYPES.register(new ResourceLocation("undefined"), MobType.f_21640_);
            MobTypePredicate.MOB_TYPES.register(new ResourceLocation("undead"), MobType.f_21641_);
            MobTypePredicate.MOB_TYPES.register(new ResourceLocation("arthropod"), MobType.f_21642_);
            MobTypePredicate.MOB_TYPES.register(new ResourceLocation("illager"), MobType.f_21643_);
            MobTypePredicate.MOB_TYPES.register(new ResourceLocation("water"), MobType.f_21644_);
            DamageSourcePredicate.LOADER.register(Mantle.getResource("has_entity"), DamageSourcePredicate.HAS_ENTITY.getLoader());
            DamageSourcePredicate.LOADER.register(Mantle.getResource("is_indirect"), DamageSourcePredicate.IS_INDIRECT.getLoader());
            DamageSourcePredicate.LOADER.register(Mantle.getResource("can_protect"), DamageSourcePredicate.CAN_PROTECT.getLoader());
            DamageSourcePredicate.LOADER.register(Mantle.getResource("damage_type"), DamageTypePredicate.LOADER);
            DamageSourcePredicate.LOADER.register(Mantle.getResource("message"), SourceMessagePredicate.LOADER);
            DamageSourcePredicate.LOADER.register(Mantle.getResource("attacker"), SourceAttackerPredicate.LOADER);
        } else if (key == Registries.f_256922_) {
            BlockEntityTypeRegistryAdapter adapter = new BlockEntityTypeRegistryAdapter((IForgeRegistry<BlockEntityType<?>>)Objects.requireNonNull(event.getForgeRegistry()));
            Set<Block> signs = MantleSignBlockEntity.buildSignBlocks();
            if (!signs.isEmpty()) {
                adapter.register(MantleSignBlockEntity::new, signs, "sign");
            }
            if (!(signs = MantleHangingSignBlockEntity.buildSignBlocks()).isEmpty()) {
                adapter.register(MantleHangingSignBlockEntity::new, signs, "hanging_sign");
            }
        } else if (key == Registries.f_256982_) {
            ResourceOrTagKeyArgument.Info info = new ResourceOrTagKeyArgument.Info();
            ForgeRegistries.COMMAND_ARGUMENT_TYPES.register(Mantle.getResource("resource_or_tag_key"), info);
            ArgumentTypeInfos.registerByClass(RegistrationHelper.genericArgumentType(ResourceOrTagKeyArgument.class), info);
        } else {
            MantleLoot.registerGlobalLootModifiers(event);
        }
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        boolean server = event.includeServer();
        boolean client = event.includeClient();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(server, (DataProvider)new MantleBlockTagProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(server, (DataProvider)new MantleFluidTagProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(server, (DataProvider)new MantleMenuTagProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(server, (DataProvider)new MantleFluidTransferProvider(packOutput));
        generator.addProvider(client, (DataProvider)new MantleFluidTooltipProvider(packOutput));
    }

    public static ResourceLocation getResource(String name) {
        return new ResourceLocation(modId, name);
    }

    public static ResourceLocation commonResource(String name) {
        return new ResourceLocation(COMMON, name);
    }

    public static String makeDescriptionId(String base, String name) {
        return Util.m_137492_((String)base, (ResourceLocation)Mantle.getResource(name));
    }

    public static MutableComponent makeComponent(String base, String name) {
        return Component.m_237115_((String)Mantle.makeDescriptionId(base, name));
    }

    public static MutableComponent makeComponent(String base, String name, Object ... args) {
        return Component.m_237110_((String)Mantle.makeDescriptionId(base, name), (Object[])args);
    }
}

