/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.adapter;

import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;

public class RegistryAdapter<T> {
    private final IForgeRegistry<T> registry;
    private final String modId;

    public RegistryAdapter(IForgeRegistry<T> registry) {
        this(registry, ModLoadingContext.get().getActiveContainer().getModId());
    }

    public ResourceLocation getResource(String name) {
        return new ResourceLocation(this.modId, name);
    }

    public String resourceName(String name) {
        return this.modId + ":" + name;
    }

    public <I extends T> I register(I entry, String name) {
        return this.register(entry, this.getResource(name));
    }

    public <I extends T> I register(I entry, T name) {
        return this.register(entry, Objects.requireNonNull(this.registry.getKey(name)));
    }

    public <I extends T> I register(I entry, ResourceLocation location) {
        this.registry.register(location, entry);
        return entry;
    }

    public RegistryAdapter(IForgeRegistry<T> registry, String modId) {
        this.registry = registry;
        this.modId = modId;
    }
}

