/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.loot.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import slimeknights.mantle.loot.MantleLoot;
import slimeknights.mantle.util.JsonHelper;

public record HasLootContextSetCondition(LootContextParamSet set) implements LootItemCondition
{
    public static Builder builder(LootContextParamSet set) {
        return new Builder(set);
    }

    public LootItemConditionType m_7940_() {
        return MantleLoot.HAS_CONTEXT_SET;
    }

    public boolean test(LootContext context) {
        for (LootContextParam param : this.set.m_81394_()) {
            if (context.m_78936_(param)) continue;
            return false;
        }
        return true;
    }

    public record Builder(LootContextParamSet set) implements LootItemCondition.Builder
    {
        public LootItemCondition m_6409_() {
            return new HasLootContextSetCondition(this.set);
        }
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<HasLootContextSetCondition> {
        public void serialize(JsonObject json, HasLootContextSetCondition value, JsonSerializationContext context) {
            json.addProperty("set", Objects.requireNonNull(LootContextParamSets.m_81426_((LootContextParamSet)value.set), "Unregistered loot LootContextParamSets").toString());
        }

        public HasLootContextSetCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            ResourceLocation key = JsonHelper.getResourceLocation(json, "set");
            LootContextParamSet set = LootContextParamSets.m_81431_((ResourceLocation)key);
            if (set == null) {
                throw new JsonSyntaxException("Unknown LootContextParamSet " + key);
            }
            return new HasLootContextSetCondition(set);
        }
    }
}

