/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.item;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.item.ConstantFluidContainerWrapper;

public class ContainerFoodItem
extends Item {
    private final UseAnim useAnim;

    public ContainerFoodItem(Item.Properties props, UseAnim useAnim) {
        super(props);
        this.useAnim = useAnim;
    }

    public ContainerFoodItem(Item.Properties props) {
        this(props, UseAnim.DRINK);
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return this.useAnim;
    }

    public static void addEffectTooltip(FoodProperties food, List<Component> tooltip) {
        for (Pair pair : food.m_38749_()) {
            MobEffectInstance effect = (MobEffectInstance)pair.getFirst();
            if (effect == null) continue;
            MutableComponent mutable = Component.m_237115_((String)effect.m_19576_());
            if (effect.m_19564_() > 0) {
                mutable = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutable, Component.m_237115_((String)("potion.potency." + effect.m_19564_()))});
            }
            if (effect.m_19557_() > 20) {
                mutable = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutable, MobEffectUtil.m_267641_((MobEffectInstance)effect, (float)1.0f)});
            }
            tooltip.add((Component)mutable.m_130940_(effect.m_19544_().m_19483_().m_19497_()));
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        FoodProperties food = stack.getFoodProperties(null);
        if (food != null) {
            ContainerFoodItem.addEffectTooltip(food, tooltip);
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity living) {
        Player p;
        Player player;
        ItemStack container = stack.getCraftingRemainingItem();
        ItemStack result = super.m_5922_(stack, level, living);
        Player player2 = player = living instanceof Player ? (p = (Player)living) : null;
        if (!(container.m_41619_() || player != null && player.m_150110_().f_35937_)) {
            container = container.m_41777_();
            if (result.m_41619_()) {
                return container;
            }
            if (player != null && !player.m_150109_().m_36054_(container)) {
                player.m_36176_(container, false);
            }
        }
        return result;
    }

    public static class FluidContainerFoodItem
    extends ContainerFoodItem {
        private final Supplier<FluidStack> fluid;

        public FluidContainerFoodItem(Item.Properties props, Supplier<FluidStack> fluid) {
            super(props);
            this.fluid = fluid;
        }

        @Nullable
        public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
            return new ConstantFluidContainerWrapper(this.fluid.get(), stack);
        }
    }
}

