/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.predicate.fluid;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.loadable.record.SingletonLoader;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.RegistryPredicateRegistry;
import slimeknights.mantle.util.RegistryHelper;

public interface FluidPredicate
extends IJsonPredicate<Fluid> {
    public static final FluidPredicate ANY = FluidPredicate.simple(fluid -> true);
    public static final FluidPredicate NONE = FluidPredicate.simple(fluid -> false);
    public static final RegistryPredicateRegistry<Fluid, Fluid> LOADER = new RegistryPredicateRegistry<Fluid, Fluid>("Fluid Predicate", ANY, NONE, Loadables.FLUID, Function.identity(), "fluids", Loadables.FLUID_TAG, RegistryHelper::contains);
    public static final FluidPredicate SOURCE = FluidPredicate.simple(fluid -> fluid.m_7444_(fluid.m_76145_()));
    public static final FluidPredicate HAS_BUCKET = FluidPredicate.simple(fluid -> fluid.m_6859_() != Items.f_41852_);
    public static final FluidPredicate LIGHTER_THAN_AIR = FluidPredicate.simple(fluid -> fluid.getFluidType().isLighterThanAir());

    @Override
    default public IJsonPredicate<Fluid> inverted() {
        return LOADER.invert(this);
    }

    public static FluidPredicate simple(final Predicate<Fluid> predicate) {
        return SingletonLoader.singleton(loader -> new FluidPredicate(){
            final /* synthetic */ RecordLoadable val$loader;
            {
                this.val$loader = recordLoadable;
            }

            @Override
            public boolean matches(Fluid fluid) {
                return predicate.test(fluid);
            }

            @Override
            public RecordLoadable<? extends FluidPredicate> getLoader() {
                return this.val$loader;
            }
        });
    }

    public static IJsonPredicate<Fluid> set(Fluid ... fluids) {
        return LOADER.setOf((Fluid[])fluids);
    }

    public static IJsonPredicate<Fluid> tag(TagKey<Fluid> tag) {
        return LOADER.tag(tag);
    }

    @SafeVarargs
    public static IJsonPredicate<Fluid> and(IJsonPredicate<Fluid> ... predicates) {
        return LOADER.and(List.of(predicates));
    }

    @SafeVarargs
    public static IJsonPredicate<Fluid> or(IJsonPredicate<Fluid> ... predicates) {
        return LOADER.or(List.of(predicates));
    }
}

