/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.common;

import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.loadable.primitive.ResourceLocationLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public interface BaseRegistryLoadable<T>
extends ResourceLocationLoadable<T> {
    @Nullable
    public Registry<T> registry();

    public ResourceLocation registryId();

    @Override
    default public T fromKey(ResourceLocation name, String key, TypedMap context) {
        Object value;
        Registry<T> registry = this.registry();
        if (registry != null && registry.m_7804_(name) && (value = registry.m_7745_(name)) != null) {
            return (T)value;
        }
        throw new JsonSyntaxException("Unable to parse " + key + " as registry " + this.registryId() + " does not contain ID " + name);
    }

    @Override
    default public ResourceLocation getKey(T object) {
        ResourceLocation location;
        Registry<T> registry = this.registry();
        if (registry != null && (location = registry.m_7981_(object)) != null) {
            return location;
        }
        throw new RuntimeException("Registry " + this.registryId() + " does not contain object " + object);
    }

    @Override
    default public T decode(FriendlyByteBuf buffer, TypedMap context) {
        Object value;
        int id = buffer.m_130242_();
        Registry<T> registry = this.registry();
        if (registry != null && (value = registry.m_7942_(id)) != null) {
            return (T)value;
        }
        throw new DecoderException("Registry " + this.registryId() + " does not contain ID " + id);
    }

    @Override
    default public void encode(FriendlyByteBuf buffer, T object) {
        Registry<T> registry = this.registry();
        if (registry == null) {
            throw new EncoderException("Registry " + this.registryId() + " cannot be located");
        }
        buffer.m_236818_(registry, object);
    }
}

