/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util.html;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import slimeknights.mantle.util.html.HtmlSerializable;
import slimeknights.mantle.util.html.HtmlString;

public class HtmlGroup
implements HtmlSerializable {
    protected final boolean indentChildren;
    protected final List<HtmlSerializable> children = new ArrayList<HtmlSerializable>();

    public static HtmlGroup indent() {
        return new HtmlGroup(true);
    }

    public static HtmlGroup inline() {
        return new HtmlGroup(false);
    }

    public HtmlGroup add(HtmlSerializable element) {
        this.children.add(element);
        return this;
    }

    public HtmlGroup add(HtmlSerializable ... elements) {
        for (HtmlSerializable element : elements) {
            this.add(element);
        }
        return this;
    }

    public HtmlGroup add(String text) {
        return this.add((HtmlSerializable)new HtmlString(text));
    }

    public String toHtml() {
        StringBuilder builder = new StringBuilder();
        this.toHtml(builder, "");
        return builder.toString();
    }

    @Override
    public void toHtml(StringBuilder builder, String indent) {
        if (this.indentChildren) {
            for (HtmlSerializable element : this.children) {
                builder.append(indent);
                element.toHtml(builder, indent);
                builder.append('\n');
            }
        } else {
            for (HtmlSerializable element : this.children) {
                element.toHtml(builder, indent);
            }
        }
    }

    public String toString() {
        return "Group[" + this.children.stream().map(Object::toString).collect(Collectors.joining(",")) + "]";
    }

    protected HtmlGroup(boolean indentChildren) {
        this.indentChildren = indentChildren;
    }
}

