/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public class ItemStackList
extends NonNullList<ItemStack> {
    protected ItemStackList() {
        this(new ArrayList<ItemStack>());
    }

    protected ItemStackList(List<ItemStack> delegate) {
        super(delegate, (Object)ItemStack.f_41583_);
    }

    public static ItemStackList create() {
        return new ItemStackList();
    }

    public static ItemStackList withSize(int size) {
        Object[] aobject = new ItemStack[size];
        Arrays.fill(aobject, ItemStack.f_41583_);
        return new ItemStackList(Arrays.asList(aobject));
    }

    public static ItemStackList of(ItemStack ... element) {
        ItemStackList itemStackList = ItemStackList.create();
        itemStackList.addAll(Arrays.asList(element));
        return itemStackList;
    }

    public static ItemStackList of(Collection<ItemStack> boringList) {
        ItemStackList itemStackList = ItemStackList.create();
        itemStackList.addAll(boringList);
        return itemStackList;
    }

    public static ItemStackList of(Container inventory) {
        ItemStackList itemStackList = ItemStackList.withSize(inventory.m_6643_());
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            itemStackList.add(inventory.m_8020_(i));
        }
        return itemStackList;
    }

    public boolean hasItem(int index) {
        return index >= 0 && index < this.size() && !((ItemStack)this.get(index)).m_41619_();
    }

    public void setEmpty(int index) {
        if (index >= 0 && index < this.size()) {
            this.set(index, ItemStack.f_41583_);
        }
    }

    public ItemStackList copy(boolean fixed) {
        ItemStackList copy = fixed ? ItemStackList.withSize(this.size()) : ItemStackList.create();
        for (int i = 0; i < this.size(); ++i) {
            copy.set(i, (ItemStack)this.get(i));
        }
        return copy;
    }

    public ItemStackList deepCopy(boolean fixed) {
        ItemStackList copy = fixed ? ItemStackList.withSize(this.size()) : ItemStackList.create();
        for (int i = 0; i < this.size(); ++i) {
            copy.set(i, ((ItemStack)this.get(i)).m_41777_());
        }
        return copy;
    }
}

