/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.predicate;

import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.PredicateRegistry;

public class TagPredicateRegistry<R, T>
extends PredicateRegistry<T> {
    private final BiPredicate<TagKey<R>, T> tagMatcher;
    private final RecordLoadable<TagPredicate> tagLoader;

    public TagPredicateRegistry(String name, IJsonPredicate<T> anyInstance, @Nullable IJsonPredicate<T> noneInstance, Loadable<TagKey<R>> tagKey, BiPredicate<TagKey<R>, T> tagMatcher) {
        super(name, anyInstance, noneInstance);
        this.tagMatcher = tagMatcher;
        this.tagLoader = RecordLoadable.create(tagKey.requiredField("tag", p -> p.tag), x$0 -> new TagPredicate(x$0));
        this.register(Mantle.getResource("tag"), this.tagLoader);
    }

    @Deprecated(forRemoval=true)
    public TagPredicateRegistry(String name, IJsonPredicate<T> anyInstance, Loadable<TagKey<R>> tagKey, BiPredicate<TagKey<R>, T> tagMatcher) {
        this(name, anyInstance, null, tagKey, tagMatcher);
    }

    public IJsonPredicate<T> tag(TagKey<R> tag) {
        return new TagPredicate(tag);
    }

    private class TagPredicate
    implements IJsonPredicate<T> {
        private final TagKey<R> tag;

        @Override
        public boolean matches(T input) {
            return TagPredicateRegistry.this.tagMatcher.test(this.tag, (TagKey)input);
        }

        @Override
        public IJsonPredicate<T> inverted() {
            return TagPredicateRegistry.this.invert(this);
        }

        @Override
        public RecordLoadable<? extends IJsonPredicate<T>> getLoader() {
            return TagPredicateRegistry.this.tagLoader;
        }

        public TagPredicate(TagKey<R> tag) {
            this.tag = tag;
        }
    }
}

