/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.primitive;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.mapping.EnumMapLoadable;
import slimeknights.mantle.data.loadable.mapping.EnumSetLoadable;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public record EnumLoadable<E extends Enum<E>>(Class<E> enumClass, E[] allowedValues) implements StringLoadable<E>
{
    public EnumLoadable(Class<E> enumClass) {
        this(enumClass, (Enum[])enumClass.getEnumConstants());
    }

    @SafeVarargs
    public static <E extends Enum<E>> EnumLoadable<E> of(E ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Must have at least 1 value for an enum loadable");
        }
        return new EnumLoadable(((Enum)values[0]).getDeclaringClass(), values);
    }

    @Override
    public E parseString(String name, String key, TypedMap context) {
        for (E value : this.allowedValues) {
            if (!((Enum)value).name().toLowerCase(Locale.ROOT).equals(name)) continue;
            return value;
        }
        throw new JsonSyntaxException("Invalid " + this.enumClass.getSimpleName() + " " + name);
    }

    @Override
    public String getString(E object) {
        return ((Enum)object).name().toLowerCase(Locale.ROOT);
    }

    @Override
    public E decode(FriendlyByteBuf buffer, TypedMap context) {
        return (E)buffer.m_130066_(this.enumClass);
    }

    @Override
    public void encode(FriendlyByteBuf buffer, E object) {
        buffer.m_130068_(object);
    }

    @Override
    public Loadable<Set<E>> set(int minSize) {
        return new EnumSetLoadable(this, minSize);
    }

    @Override
    public <V> Loadable<Map<E, V>> mapWithValues(Loadable<V> valueLoadable, int minSize) {
        return new EnumMapLoadable(this, valueLoadable, minSize);
    }

    @Override
    public <P> LoadableField<E, P> nullableField(String key, Function<P, E> getter) {
        return new NullableEnumField<E, P>(this, key, getter);
    }

    private record NullableEnumField<E extends Enum<E>, P>(EnumLoadable<E> loadable, String key, Function<P, E> getter) implements LoadableField<E, P>
    {
        @Override
        @Nullable
        public E get(JsonObject json, String key, TypedMap context) {
            return (E)((Enum)this.loadable.getOrDefault(json, key, null, context));
        }

        @Override
        public void serialize(P parent, JsonObject json) {
            Enum value = (Enum)this.getter.apply(parent);
            if (value != null) {
                json.add(this.key, this.loadable.serialize(value));
            }
        }

        @Override
        @Nullable
        public E decode(FriendlyByteBuf buffer, TypedMap context) {
            Enum[] values;
            int index = buffer.m_130242_();
            if (index == (values = (Enum[])this.loadable.enumClass.getEnumConstants()).length) {
                return null;
            }
            return (E)values[index];
        }

        @Override
        public void encode(FriendlyByteBuf buffer, P parent) {
            Enum value = (Enum)this.getter.apply(parent);
            if (value == null) {
                buffer.m_130130_(((Enum[])this.loadable.enumClass.getEnumConstants()).length);
            } else {
                buffer.m_130130_(value.ordinal());
            }
        }
    }
}

