/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.model.builder.ColoredModelBuilder;

public class ConnectedModelBuilder<T extends ModelBuilder<T>>
extends ColoredModelBuilder<T> {
    private final JsonObject connectedTextures = new JsonObject();
    private Set<Direction> sides = null;
    private String predicate = null;

    public ConnectedModelBuilder(T parent, ExistingFileHelper existingFileHelper) {
        super(Mantle.getResource("connected"), parent, existingFileHelper);
    }

    public ConnectedModelBuilder<T> connected(String name, String type) {
        this.connectedTextures.addProperty(name, type);
        return this;
    }

    public ConnectedModelBuilder<T> setSides(Direction first, Direction ... other) {
        this.sides = EnumSet.of(first, other);
        return this;
    }

    public ConnectedModelBuilder<T> setPredicate(String predicate) {
        this.predicate = predicate;
        return this;
    }

    @Override
    public JsonObject toJson(JsonObject json) {
        json = super.toJson(json);
        JsonObject data = new JsonObject();
        json.add("connection", (JsonElement)data);
        data.add("textures", (JsonElement)this.connectedTextures);
        if (this.sides != null) {
            JsonArray sides = new JsonArray();
            for (Direction side : this.sides) {
                sides.add(side.m_7912_());
            }
            data.add("sides", (JsonElement)sides);
        }
        if (this.predicate != null) {
            data.addProperty("predicate", this.predicate);
        }
        return json;
    }
}

