/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.crafting;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.recipe.MantleRecipes;

public class ShapedRetexturedRecipeBuilder {
    private final ShapedRecipeBuilder parent;
    private Ingredient texture = null;
    private char textureKey = '\u0000';
    private boolean matchAll = false;

    public ShapedRetexturedRecipeBuilder setSource(Ingredient texture) {
        this.texture = texture;
        this.textureKey = '\u0000';
        return this;
    }

    public ShapedRetexturedRecipeBuilder setSource(TagKey<Item> tag) {
        return this.setSource(Ingredient.m_204132_(tag));
    }

    public ShapedRetexturedRecipeBuilder setSource(char textureKey) {
        this.textureKey = textureKey;
        this.texture = null;
        return this;
    }

    public ShapedRetexturedRecipeBuilder setMatchAll() {
        this.matchAll = true;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        this.validate();
        this.parent.m_176498_(base -> consumer.accept(new Result((FinishedRecipe)base)));
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation location) {
        this.validate();
        this.parent.m_126140_(base -> consumer.accept(new Result((FinishedRecipe)base)), location);
    }

    private void validate() {
        if (this.texture == null && this.textureKey == '\u0000') {
            throw new IllegalStateException("No texture defined for texture recipe");
        }
    }

    private ShapedRetexturedRecipeBuilder(ShapedRecipeBuilder parent) {
        this.parent = parent;
    }

    public static ShapedRetexturedRecipeBuilder fromShaped(ShapedRecipeBuilder parent) {
        return new ShapedRetexturedRecipeBuilder(parent);
    }

    private class Result
    implements FinishedRecipe {
        private final FinishedRecipe base;

        private Result(FinishedRecipe base) {
            this.base = base;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)MantleRecipes.CRAFTING_SHAPED_RETEXTURED.get();
        }

        public ResourceLocation m_6445_() {
            return this.base.m_6445_();
        }

        public void m_7917_(JsonObject json) {
            this.base.m_7917_(json);
            if (ShapedRetexturedRecipeBuilder.this.textureKey != '\u0000') {
                json.addProperty("texture", Character.valueOf(ShapedRetexturedRecipeBuilder.this.textureKey));
            } else if (ShapedRetexturedRecipeBuilder.this.texture != null) {
                json.add("texture", ShapedRetexturedRecipeBuilder.this.texture.m_43942_());
                Mantle.logger.warn("Using deprecated ingredient format on texture for shaped retextured recipe {}. Use key instead.", (Object)this.m_6445_());
            }
            json.addProperty("match_all", Boolean.valueOf(ShapedRetexturedRecipeBuilder.this.matchAll));
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.base.m_5860_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.base.m_6448_();
        }
    }
}

