/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.command.MantleCommand;
import slimeknights.mantle.command.argument.TagSource;
import slimeknights.mantle.command.argument.TagSourceArgument;

public class ViewTagCommand {
    private static final Component EMPTY = Component.m_237115_((String)"command.mantle.tag.empty");
    protected static final Dynamic2CommandExceptionType TAG_NOT_FOUND = new Dynamic2CommandExceptionType((type, name) -> Component.m_237110_((String)"command.mantle.tag.not_found", (Object[])new Object[]{type, name}));

    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        ((LiteralArgumentBuilder)subCommand.requires(source -> MantleCommand.requiresDebugInfoOrOp(source, 2))).then(TagSourceArgument.argument().then(TagSourceArgument.tagArgument("name").executes(ViewTagCommand::run)));
    }

    private static <T> int runGeneric(CommandContext<CommandSourceStack> context, TagSource<T> registry) throws CommandSyntaxException {
        ResourceLocation name = (ResourceLocation)context.getArgument("name", ResourceLocation.class);
        List<ResourceLocation> values = registry.keysInTag(name);
        if (values != null) {
            MutableComponent output = Component.m_237110_((String)"command.mantle.view_tag.success", (Object[])new Object[]{registry.key().m_135782_(), name});
            if (values.isEmpty()) {
                output.m_130946_("\n* ").m_7220_(EMPTY);
            } else {
                for (ResourceLocation value : values) {
                    output.m_130946_("\n* " + Objects.requireNonNull(value));
                }
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> output, true);
            return values.size();
        }
        throw TAG_NOT_FOUND.create((Object)registry.key().m_135782_(), (Object)name);
    }

    private static int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return ViewTagCommand.runGeneric(context, TagSourceArgument.get(context));
    }
}

