/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book.element;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.joml.Vector2i;
import slimeknights.mantle.client.screen.book.BookScreen;

public abstract class BookElement {
    public BookScreen parent;
    protected Minecraft mc = Minecraft.m_91087_();
    protected TextureManager renderEngine;
    public int x;
    public int y;
    private static final ClientTooltipPositioner POSITIONER = (screenWidth, screenHeight, mouseX, mouseY, tooltipWidth, tooltipHeight) -> {
        Vector2i pos = new Vector2i(mouseX, mouseY).add(12, -12);
        if (pos.x + tooltipWidth > 182) {
            pos.x = Math.max(pos.x - 24 - tooltipWidth, 4);
        }
        if (pos.y + (tooltipHeight += 3) > 176) {
            pos.y = 176 - tooltipHeight;
        }
        return pos;
    };

    public BookElement(int x, int y) {
        this.renderEngine = this.mc.f_90987_;
        this.x = x;
        this.y = y;
    }

    public abstract void draw(GuiGraphics var1, int var2, int var3, float var4, Font var5);

    public void drawOverlay(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, Font fontRenderer) {
    }

    public void mouseClicked(double mouseX, double mouseY, int mouseButton) {
    }

    public void mouseReleased(double mouseX, double mouseY, int clickedMouseButton) {
    }

    public void mouseDragged(double clickX, double clickY, double mx, double my, double lastX, double lastY, int button) {
    }

    public void renderToolTip(GuiGraphics graphics, Font fontRenderer, ItemStack stack, int x, int y) {
        List list = stack.m_41651_((Player)this.mc.f_91074_, (TooltipFlag)(this.mc.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
        Font font = IClientItemExtensions.of((ItemStack)stack).getFont(stack, IClientItemExtensions.FontContext.TOOLTIP);
        if (font == null) {
            font = fontRenderer;
        }
        this.drawTooltip(graphics, list, x, y, font);
    }

    private static Stream<ClientTooltipComponent> splitLine(FormattedText text, Font font, int maxWidth) {
        Component component;
        if (text instanceof Component && (component = (Component)text).getString().isEmpty()) {
            return Stream.of(component.m_7532_()).map(ClientTooltipComponent::m_169948_);
        }
        return font.m_92923_(text, maxWidth).stream().map(ClientTooltipComponent::m_169948_);
    }

    public void drawTooltip(GuiGraphics graphics, List<Component> textLines, int mouseX, int mouseY, Font font) {
        int tooltipTextWidth = textLines.stream().mapToInt(arg_0 -> ((Font)font).m_92852_(arg_0)).max().orElse(0);
        boolean needsWrap = false;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > 182 && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > 91 ? mouseX - 12 - 8 : 166 - mouseX;
            needsWrap = true;
        }
        int tooltipTextWidthF = tooltipTextWidth;
        List<ClientTooltipComponent> components = needsWrap ? textLines.stream().flatMap(text -> BookElement.splitLine((FormattedText)text, font, tooltipTextWidthF)).toList() : textLines.stream().map(text -> ClientTooltipComponent.m_169948_((FormattedCharSequence)text.m_7532_())).toList();
        graphics.m_280497_(font, components, mouseX, mouseY, POSITIONER);
    }

    public void setParent(BookScreen parent) {
        this.parent = parent;
    }
}

