/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.FalseCondition;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fml.ModList;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.util.JsonHelper;

public class GeneratePackHelper {
    private static final String PACK_NAME = "SlimeKnightsGenerated";
    private static final String PACK_DESCRIPTION = "Data pack generated by commands from SlimeKnights mods.";
    public static final DynamicCommandExceptionType FAILED_SAVE = new DynamicCommandExceptionType(id -> Mantle.makeComponent("command", "remove.failed_save", id));

    private GeneratePackHelper() {
    }

    public static Path getDatapackPath(MinecraftServer server, String packName) {
        if (ModList.get().isLoaded("jsonthings")) {
            return server.m_6237_().toPath().resolve("thingpacks/" + packName);
        }
        return server.m_129843_(LevelResource.f_78180_).resolve(packName);
    }

    public static Path getDatapackPath(MinecraftServer server) {
        return GeneratePackHelper.getDatapackPath(server, PACK_NAME);
    }

    public static boolean saveJson(JsonElement element, Path path) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            String json = JsonHelper.DEFAULT_GSON.toJson(element);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                bufferedwriter.write(json);
            }
            return true;
        }
        catch (IOException e) {
            Mantle.logger.error("Couldn't create JSON at {}", (Object)path, (Object)e);
            return false;
        }
    }

    public static boolean saveConditionRemove(Path path, String conditionKey) {
        JsonObject json = new JsonObject();
        json.add(conditionKey, (JsonElement)CraftingHelper.serialize((ICondition[])new ICondition[]{FalseCondition.INSTANCE}));
        return GeneratePackHelper.saveJson((JsonElement)json, path);
    }

    public static boolean saveConditionRemove(Path path) {
        return GeneratePackHelper.saveConditionRemove(path, "forge:conditions");
    }

    public static void saveMcmeta(Path folder, PackType packType, String description) {
        Path path = folder.resolve("pack.mcmeta");
        JsonObject meta = new JsonObject();
        JsonObject pack = new JsonObject();
        pack.addProperty("description", description);
        pack.addProperty("pack_format", (Number)SharedConstants.m_183709_().m_264084_(packType));
        meta.add("pack", (JsonElement)pack);
        GeneratePackHelper.saveJson((JsonElement)meta, path);
    }

    public static void saveMcmeta(Path folder) {
        GeneratePackHelper.saveMcmeta(folder, PackType.SERVER_DATA, PACK_DESCRIPTION);
    }

    public static Component getOutputComponent(File file) {
        return GeneratePackHelper.getOutputComponent(file.getAbsolutePath());
    }

    public static Component getOutputComponent(Path path) {
        return GeneratePackHelper.getOutputComponent(path.toString());
    }

    public static Component getOutputComponent(String path) {
        return GeneratePackHelper.getPathComponent(Component.m_237113_((String)path), path);
    }

    public static MutableComponent getPathComponent(MutableComponent text, String path) {
        return text.m_130938_(style -> style.m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, path)));
    }
}

