/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.predicate.damage;

import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.mantle.data.loadable.primitive.EnumLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.damage.DamageSourcePredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;

public record EntityDamageSourcePredicate(WhichEntity which, IJsonPredicate<LivingEntity> predicate) implements DamageSourcePredicate
{
    public static final RecordLoadable<EntityDamageSourcePredicate> LOADER = RecordLoadable.create(new EnumLoadable<WhichEntity>(WhichEntity.class).defaultField("which", WhichEntity.CAUSING, true, EntityDamageSourcePredicate::which), LivingEntityPredicate.LOADER.directField("entity_type", EntityDamageSourcePredicate::predicate), EntityDamageSourcePredicate::new);

    public static EntityDamageSourcePredicate causing(IJsonPredicate<LivingEntity> predicate) {
        return new EntityDamageSourcePredicate(WhichEntity.CAUSING, predicate);
    }

    public static EntityDamageSourcePredicate direct(IJsonPredicate<LivingEntity> predicate) {
        return new EntityDamageSourcePredicate(WhichEntity.DIRECT, predicate);
    }

    @Override
    public boolean matches(DamageSource input) {
        Entity entity = this.which.get(input);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return this.predicate.matches(living);
        }
        return this.predicate == LivingEntityPredicate.ANY && entity != null;
    }

    public RecordLoadable<EntityDamageSourcePredicate> getLoader() {
        return LOADER;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum WhichEntity {
        CAUSING{

            @Override
            public Entity get(DamageSource source) {
                return source.m_7639_();
            }
        }
        ,
        DIRECT{

            @Override
            @Nullable
            public Entity get(DamageSource source) {
                return source.m_7640_();
            }
        };


        @Nullable
        public abstract Entity get(DamageSource var1);
    }
}

