/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public final class RetexturedHelper {
    public static final String TAG_TEXTURE = "texture";
    public static final ModelProperty<Block> BLOCK_PROPERTY = new ModelProperty(block -> block != Blocks.f_50016_);

    public static Block getBlock(String name) {
        ResourceLocation location;
        if (!name.isEmpty() && (location = ResourceLocation.m_135820_((String)name)) != null) {
            return (Block)Registry.f_122824_.m_7745_(location);
        }
        return Blocks.f_50016_;
    }

    public static String getTextureName(@Nullable CompoundTag nbt) {
        if (nbt == null) {
            return "";
        }
        return nbt.m_128461_(TAG_TEXTURE);
    }

    public static String getTextureName(Block block) {
        if (block == Blocks.f_50016_) {
            return "";
        }
        return Objects.requireNonNull(Registry.f_122824_.m_7981_((Object)block)).toString();
    }

    public static void setTexture(@Nullable CompoundTag nbt, String texture) {
        if (nbt != null) {
            if (texture.isEmpty()) {
                nbt.m_128473_(TAG_TEXTURE);
            } else {
                nbt.m_128359_(TAG_TEXTURE, texture);
            }
        }
    }

    public static void onTextureUpdated(BlockEntity self) {
        Level level = self.m_58904_();
        if (level != null && level.f_46443_) {
            self.requestModelDataUpdate();
            BlockState state = self.m_58900_();
            level.m_7260_(self.m_58899_(), state, state, 0);
        }
    }

    public static ModelData.Builder getModelDataBuilder(Block block) {
        if (block == Blocks.f_50016_) {
            block = null;
        }
        return ModelData.builder().with(BLOCK_PROPERTY, (Object)block);
    }

    public static ModelData getModelData(Block block) {
        return RetexturedHelper.getModelDataBuilder(block).build();
    }

    private RetexturedHelper() {
    }
}

