/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.deferred;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WoodButtonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.block.MantleStandingSignBlock;
import slimeknights.mantle.block.MantleWallSignBlock;
import slimeknights.mantle.block.StrippableLogBlock;
import slimeknights.mantle.block.WoodenDoorBlock;
import slimeknights.mantle.block.entity.MantleSignBlockEntity;
import slimeknights.mantle.item.BurnableBlockItem;
import slimeknights.mantle.item.BurnableSignItem;
import slimeknights.mantle.item.BurnableTallBlockItem;
import slimeknights.mantle.registration.RegistrationHelper;
import slimeknights.mantle.registration.deferred.DeferredRegisterWrapper;
import slimeknights.mantle.registration.deferred.SynchronizedDeferredRegister;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.FenceBuildingBlockObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.mantle.registration.object.MetalItemObject;
import slimeknights.mantle.registration.object.WallBuildingBlockObject;
import slimeknights.mantle.registration.object.WoodBlockObject;

public class BlockDeferredRegister
extends DeferredRegisterWrapper<Block> {
    protected final SynchronizedDeferredRegister<Item> itemRegister;

    public BlockDeferredRegister(String modID) {
        super(Registry.f_122901_, modID);
        this.itemRegister = SynchronizedDeferredRegister.create(ForgeRegistries.ITEMS, modID);
    }

    @Override
    public void register(IEventBus bus) {
        super.register(bus);
        this.itemRegister.register(bus);
    }

    public <B extends Block> RegistryObject<B> registerNoItem(String name, Supplier<? extends B> block) {
        return this.register.register(name, block);
    }

    public RegistryObject<Block> registerNoItem(String name, BlockBehaviour.Properties props) {
        return this.registerNoItem(name, () -> new Block(props));
    }

    public <B extends Block> ItemObject<B> register(String name, Supplier<? extends B> block, Function<? super B, ? extends BlockItem> item) {
        RegistryObject blockObj = this.registerNoItem(name, block);
        this.itemRegister.register(name, () -> (BlockItem)item.apply((Object)blockObj.get()));
        return new ItemObject<B>(blockObj);
    }

    public ItemObject<Block> register(String name, BlockBehaviour.Properties blockProps, Function<? super Block, ? extends BlockItem> item) {
        return this.register(name, () -> new Block(blockProps), item);
    }

    public BuildingBlockObject registerBuilding(String name, Supplier<? extends Block> block, Function<? super Block, ? extends BlockItem> item) {
        ItemObject<? super Block> blockObj = this.register(name, block, item);
        return new BuildingBlockObject(blockObj, this.register(name + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)blockObj.get()))), item), this.register(name + "_stairs", () -> new StairBlock(() -> ((Block)blockObj.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)blockObj.get()))), item));
    }

    public BuildingBlockObject registerBuilding(String name, BlockBehaviour.Properties props, Function<? super Block, ? extends BlockItem> item) {
        ItemObject<Block> blockObj = this.register(name, props, item);
        return new BuildingBlockObject(blockObj, this.register(name + "_slab", () -> new SlabBlock(props), item), this.register(name + "_stairs", () -> new StairBlock(() -> ((Block)blockObj.get()).m_49966_(), props), item));
    }

    public WallBuildingBlockObject registerWallBuilding(String name, Supplier<? extends Block> block, Function<? super Block, ? extends BlockItem> item) {
        BuildingBlockObject obj = this.registerBuilding(name, block, item);
        return new WallBuildingBlockObject(obj, this.register(name + "_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)obj.get()))), item));
    }

    public WallBuildingBlockObject registerWallBuilding(String name, BlockBehaviour.Properties props, Function<? super Block, ? extends BlockItem> item) {
        return new WallBuildingBlockObject(this.registerBuilding(name, props, item), this.register(name + "_wall", () -> new WallBlock(props), item));
    }

    public FenceBuildingBlockObject registerFenceBuilding(String name, Supplier<? extends Block> block, Function<? super Block, ? extends BlockItem> item) {
        BuildingBlockObject obj = this.registerBuilding(name, block, item);
        return new FenceBuildingBlockObject(obj, this.register(name + "_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)obj.get()))), item));
    }

    public FenceBuildingBlockObject registerFenceBuilding(String name, BlockBehaviour.Properties props, Function<? super Block, ? extends BlockItem> item) {
        return new FenceBuildingBlockObject(this.registerBuilding(name, props, item), this.register(name + "_fence", () -> new FenceBlock(props), item));
    }

    public WoodBlockObject registerWood(String name, Function<WoodBlockObject.WoodVariant, BlockBehaviour.Properties> behaviorCreator, boolean flammable, CreativeModeTab group) {
        BiFunction<Block, Block, BlockItem> burnableSignItem;
        Function<Block, BlockItem> burnableTallItem;
        Function<Integer, Function> burnableItem;
        WoodType woodType = WoodType.create((String)this.resourceName(name));
        RegistrationHelper.registerWoodType(woodType);
        Item.Properties itemProps = new Item.Properties().m_41491_(group);
        Item.Properties signProps = new Item.Properties().m_41487_(16).m_41491_(group);
        if (flammable) {
            burnableItem = burnTime -> block -> new BurnableBlockItem((Block)block, itemProps, (int)burnTime);
            burnableTallItem = block -> new BurnableTallBlockItem((Block)block, itemProps, 200);
            burnableSignItem = (standing, wall) -> new BurnableSignItem(signProps, (Block)standing, (Block)wall, 200);
        } else {
            Function<Block, BlockItem> defaultItemBlock = block -> new BlockItem(block, itemProps);
            burnableItem = burnTime -> defaultItemBlock;
            burnableTallItem = block -> new DoubleHighBlockItem(block, itemProps);
            burnableSignItem = (standing, wall) -> new SignItem(signProps, standing, wall);
        }
        Function burnable300 = burnableItem.apply(300);
        BlockBehaviour.Properties planksProps = behaviorCreator.apply(WoodBlockObject.WoodVariant.PLANKS).m_60913_(2.0f, 3.0f);
        BuildingBlockObject planks = this.registerBuilding(name + "_planks", planksProps, (? super Block block) -> (BlockItem)((Function)burnableItem.apply(block instanceof SlabBlock ? 150 : 300)).apply(block));
        ItemObject<FenceBlock> fence = this.register(name + "_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)planks.get()))), burnable300);
        Supplier<RotatedPillarBlock> stripped = () -> new RotatedPillarBlock(((BlockBehaviour.Properties)behaviorCreator.apply(WoodBlockObject.WoodVariant.PLANKS)).m_60978_(2.0f));
        ItemObject<RotatedPillarBlock> strippedLog = this.register("stripped_" + name + "_log", stripped, burnable300);
        ItemObject<RotatedPillarBlock> strippedWood = this.register("stripped_" + name + "_wood", stripped, burnable300);
        ItemObject<RotatedPillarBlock> log = this.register(name + "_log", () -> new StrippableLogBlock(strippedLog, ((BlockBehaviour.Properties)behaviorCreator.apply(WoodBlockObject.WoodVariant.LOG)).m_60978_(2.0f)), burnable300);
        ItemObject<RotatedPillarBlock> wood = this.register(name + "_wood", () -> new StrippableLogBlock(strippedWood, ((BlockBehaviour.Properties)behaviorCreator.apply(WoodBlockObject.WoodVariant.WOOD)).m_60978_(2.0f)), burnable300);
        ItemObject<Block> door = this.register(name + "_door", () -> new WoodenDoorBlock(((BlockBehaviour.Properties)behaviorCreator.apply(WoodBlockObject.WoodVariant.PLANKS)).m_60978_(3.0f).m_60955_()), burnableTallItem);
        ItemObject<TrapDoorBlock> trapdoor = this.register(name + "_trapdoor", () -> new TrapDoorBlock(((BlockBehaviour.Properties)behaviorCreator.apply(WoodBlockObject.WoodVariant.PLANKS)).m_60978_(3.0f).m_60955_().m_60922_(Blocks::m_50778_)), burnable300);
        ItemObject<FenceGateBlock> fenceGate = this.register(name + "_fence_gate", () -> new FenceGateBlock(planksProps), burnable300);
        BlockBehaviour.Properties redstoneProps = behaviorCreator.apply(WoodBlockObject.WoodVariant.PLANKS).m_60910_().m_60978_(0.5f);
        ItemObject<PressurePlateBlock> pressurePlate = this.register(name + "_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, redstoneProps), burnable300);
        ItemObject<WoodButtonBlock> button = this.register(name + "_button", () -> new WoodButtonBlock(redstoneProps), burnableItem.apply(100));
        RegistryObject<StandingSignBlock> standingSign = this.registerNoItem(name + "_sign", () -> new MantleStandingSignBlock(((BlockBehaviour.Properties)behaviorCreator.apply(WoodBlockObject.WoodVariant.PLANKS)).m_60910_().m_60978_(1.0f), woodType));
        RegistryObject<WallSignBlock> wallSign = this.registerNoItem(name + "_wall_sign", () -> new MantleWallSignBlock(((BlockBehaviour.Properties)behaviorCreator.apply(WoodBlockObject.WoodVariant.PLANKS)).m_60910_().m_60978_(1.0f).lootFrom((Supplier)standingSign), woodType));
        MantleSignBlockEntity.registerSignBlock(standingSign);
        MantleSignBlockEntity.registerSignBlock(wallSign);
        this.itemRegister.register(name + "_sign", () -> (BlockItem)burnableSignItem.apply((Block)standingSign.get(), (Block)wallSign.get()));
        return new WoodBlockObject(this.resource(name), woodType, planks, (Supplier<? extends Block>)log, (Supplier<? extends Block>)strippedLog, (Supplier<? extends Block>)wood, (Supplier<? extends Block>)strippedWood, (Supplier<? extends FenceBlock>)fence, (Supplier<? extends FenceGateBlock>)fenceGate, (Supplier<? extends DoorBlock>)door, (Supplier<? extends TrapDoorBlock>)trapdoor, (Supplier<? extends PressurePlateBlock>)pressurePlate, (Supplier<? extends WoodButtonBlock>)button, (Supplier<? extends StandingSignBlock>)standingSign, (Supplier<? extends WallSignBlock>)wallSign);
    }

    public <T extends Enum<T>, B extends Block> EnumObject<T, B> registerEnum(T[] values, String name, Function<T, ? extends B> mapper, Function<? super B, ? extends BlockItem> item) {
        return BlockDeferredRegister.registerEnum(values, (String)name, (T fullName, U value) -> this.register((String)fullName, () -> (Block)mapper.apply(value), item));
    }

    public <T extends Enum<T>, B extends Block> EnumObject<T, B> registerEnum(String name, T[] values, Function<T, ? extends B> mapper, Function<? super B, ? extends BlockItem> item) {
        return BlockDeferredRegister.registerEnum((String)name, values, (T fullName, U value) -> this.register((String)fullName, () -> (Block)mapper.apply(value), item));
    }

    public <T extends Enum<T>, B extends Block> EnumObject<T, B> registerEnumNoItem(T[] values, String name, Function<T, ? extends B> mapper) {
        return BlockDeferredRegister.registerEnum(values, (String)name, (T fullName, U value) -> this.registerNoItem((String)fullName, () -> (Block)mapper.apply(value)));
    }

    public MetalItemObject registerMetal(String name, String tagName, Supplier<Block> blockSupplier, Function<Block, ? extends BlockItem> blockItem, Item.Properties itemProps) {
        ItemObject<Block> block = this.register(name + "_block", blockSupplier, blockItem);
        Supplier<Item> itemSupplier = () -> new Item(itemProps);
        RegistryObject<Item> ingot = this.itemRegister.register(name + "_ingot", itemSupplier);
        RegistryObject<Item> nugget = this.itemRegister.register(name + "_nugget", itemSupplier);
        return new MetalItemObject(tagName, (ItemObject<? extends Block>)block, (Supplier<? extends Item>)ingot, (Supplier<? extends Item>)nugget);
    }

    public MetalItemObject registerMetal(String name, Supplier<Block> blockSupplier, Function<Block, ? extends BlockItem> blockItem, Item.Properties itemProps) {
        return this.registerMetal(name, name, blockSupplier, blockItem, itemProps);
    }

    public MetalItemObject registerMetal(String name, String tagName, BlockBehaviour.Properties blockProps, Function<Block, ? extends BlockItem> blockItem, Item.Properties itemProps) {
        return this.registerMetal(name, tagName, () -> new Block(blockProps), blockItem, itemProps);
    }

    public MetalItemObject registerMetal(String name, BlockBehaviour.Properties blockProps, Function<Block, ? extends BlockItem> blockItem, Item.Properties itemProps) {
        return this.registerMetal(name, name, blockProps, blockItem, itemProps);
    }
}

