/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.mapping;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;

public class MapLoadable<K, V>
implements Loadable<Map<K, V>> {
    protected final StringLoadable<K> keyLoadable;
    protected final Loadable<V> valueLoadable;
    protected final int minSize;

    public MapLoadable(StringLoadable<K> keyLoadable, Loadable<V> valueLoadable, int minSize) {
        this.keyLoadable = keyLoadable;
        this.valueLoadable = valueLoadable;
        this.minSize = minSize;
    }

    @Override
    public Map<K, V> convert(JsonElement element, String key) {
        JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)key);
        if (json.size() < this.minSize) {
            throw new JsonSyntaxException(key + " must have at least " + this.minSize + " elements");
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String mapKey = key + "'s key";
        for (Map.Entry entry : json.entrySet()) {
            String entryKey = (String)entry.getKey();
            builder.put(this.keyLoadable.parseString(entryKey, mapKey), this.valueLoadable.convert((JsonElement)entry.getValue(), entryKey));
        }
        return builder.build();
    }

    @Override
    public JsonElement serialize(Map<K, V> map) {
        if (map.size() < this.minSize) {
            throw new RuntimeException("Collection must have at least " + this.minSize + " elements");
        }
        JsonObject json = new JsonObject();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            json.add(this.keyLoadable.getString(entry.getKey()), this.valueLoadable.serialize(entry.getValue()));
        }
        return json;
    }

    @Override
    public Map<K, V> decode(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < size; ++i) {
            builder.put(this.keyLoadable.decode(buffer), this.valueLoadable.decode(buffer));
        }
        return builder.build();
    }

    @Override
    public void encode(FriendlyByteBuf buffer, Map<K, V> map) {
        buffer.m_130130_(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.keyLoadable.encode(buffer, entry.getKey());
            this.valueLoadable.encode(buffer, entry.getValue());
        }
    }

    public String toString() {
        return "MapLoadable[keyLoadable=" + this.keyLoadable + ", valueLoadable=" + this.valueLoadable + ", minSize=" + this.minSize + "]";
    }
}

