/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Vector3f;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.MultiPartBakedModel;
import net.minecraft.client.resources.model.WeightedBakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;

public class ModelHelper {
    private static final Map<Block, ResourceLocation> TEXTURE_NAME_CACHE = new ConcurrentHashMap<Block, ResourceLocation>();
    public static final ResourceManagerReloadListener LISTENER = manager -> TEXTURE_NAME_CACHE.clear();

    @Nullable
    public static <T extends BakedModel> T getBakedModel(BlockState state, Class<T> clazz) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft == null) {
            return null;
        }
        BakedModel baked = minecraft.m_91304_().m_119430_().m_110893_(state);
        if (baked instanceof MultiPartBakedModel) {
            baked = (BakedModel)((Pair)((MultiPartBakedModel)baked).f_119459_.get(0)).getRight();
        }
        if (baked instanceof WeightedBakedModel) {
            baked = ((WeightedBakedModel)baked).f_119542_;
        }
        if (clazz.isInstance(baked)) {
            return (T)((BakedModel)clazz.cast(baked));
        }
        return null;
    }

    @Nullable
    public static <T extends BakedModel> T getBakedModel(ItemLike item, Class<T> clazz) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft == null) {
            return null;
        }
        BakedModel baked = minecraft.m_91291_().m_115103_().m_109394_(item.m_5456_());
        if (clazz.isInstance(baked)) {
            return (T)((BakedModel)clazz.cast(baked));
        }
        return null;
    }

    private static ResourceLocation getParticleTextureInternal(Block block) {
        TextureAtlasSprite particle = Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(block.m_49966_()).m_6160_();
        if (particle != null) {
            return particle.m_118413_();
        }
        return MissingTextureAtlasSprite.m_118071_();
    }

    public static ResourceLocation getParticleTexture(Block block) {
        return TEXTURE_NAME_CACHE.computeIfAbsent(block, ModelHelper::getParticleTextureInternal);
    }

    public static <T> T arrayToObject(JsonObject json, String name, int size, Function<float[], T> mapper) {
        JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)name);
        if (array.size() != size) {
            throw new JsonParseException("Expected " + size + " " + name + " values, found: " + array.size());
        }
        float[] vec = new float[size];
        for (int i = 0; i < size; ++i) {
            vec[i] = GsonHelper.m_13888_((JsonElement)array.get(i), (String)(name + "[" + i + "]"));
        }
        return mapper.apply(vec);
    }

    public static Vector3f arrayToVector(JsonObject json, String name) {
        return ModelHelper.arrayToObject(json, name, 3, arr -> new Vector3f(arr[0], arr[1], arr[2]));
    }

    public static JsonArray vectorToJson(Vector3f vector) {
        JsonArray array = new JsonArray();
        array.add((Number)Float.valueOf(vector.m_122239_()));
        array.add((Number)Float.valueOf(vector.m_122260_()));
        array.add((Number)Float.valueOf(vector.m_122269_()));
        return array;
    }

    public static boolean checkRotation(float rotation) {
        return rotation >= 0.0f && rotation % 90.0f == 0.0f && rotation <= 270.0f;
    }

    public static int getRotation(JsonObject json, String key) {
        int i = GsonHelper.m_13824_((JsonObject)json, (String)key, (int)0);
        if (ModelHelper.checkRotation(i)) {
            return i;
        }
        throw new JsonParseException("Invalid '" + key + "' " + i + " found, only 0/90/180/270 allowed");
    }

    private ModelHelper() {
    }
}

