/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import slimeknights.mantle.client.model.util.ColoredBlockModel;
import slimeknights.mantle.client.model.util.DynamicBakedWrapper;
import slimeknights.mantle.client.model.util.GeometryContextWrapper;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.client.model.util.ModelTextureIteratable;
import slimeknights.mantle.client.model.util.SimpleBlockModel;
import slimeknights.mantle.item.RetexturedBlockItem;
import slimeknights.mantle.util.RetexturedHelper;

public class RetexturedModel
implements IUnbakedGeometry<RetexturedModel> {
    public static IGeometryLoader<RetexturedModel> LOADER = RetexturedModel::deserialize;
    private final SimpleBlockModel model;
    private final Set<String> retextured;

    public Collection<Material> getMaterials(IGeometryBakingContext owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.model.getMaterials(owner, modelGetter, missingTextureErrors);
    }

    public BakedModel bake(IGeometryBakingContext owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ItemOverrides overrides, ResourceLocation location) {
        BakedModel baked = this.model.bake(owner, bakery, spriteGetter, transform, overrides, location);
        return new Baked(baked, owner, this.model, transform, RetexturedModel.getAllRetextured(owner, this.model, this.retextured));
    }

    public static Set<String> getAllRetextured(IGeometryBakingContext owner, SimpleBlockModel model, Set<String> originalSet) {
        HashSet retextured = Sets.newHashSet(originalSet);
        for (Map textures : ModelTextureIteratable.of(owner, model)) {
            textures.forEach((name, either) -> either.ifRight(parent -> {
                if (retextured.contains(parent)) {
                    retextured.add(name);
                }
            }));
        }
        return ImmutableSet.copyOf((Collection)retextured);
    }

    public static RetexturedModel deserialize(JsonObject json, JsonDeserializationContext context) {
        ColoredBlockModel model = ColoredBlockModel.deserialize(json, context);
        Set<String> retextured = RetexturedModel.getRetexturedNames(json);
        return new RetexturedModel(model, retextured);
    }

    public static Set<String> getRetexturedNames(JsonObject json) {
        if (json.has("retextured")) {
            JsonElement retextured = json.get("retextured");
            if (retextured.isJsonArray()) {
                JsonArray array = retextured.getAsJsonArray();
                if (array.size() == 0) {
                    throw new JsonSyntaxException("Must have at least one texture in retextured");
                }
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (int i = 0; i < array.size(); ++i) {
                    builder.add((Object)GsonHelper.m_13805_((JsonElement)array.get(i), (String)("retextured[" + i + "]")));
                }
                return builder.build();
            }
            if (retextured.isJsonPrimitive()) {
                return ImmutableSet.of((Object)retextured.getAsString());
            }
        }
        throw new JsonSyntaxException("Missing retextured, expected to find a String or a JsonArray");
    }

    protected RetexturedModel(SimpleBlockModel model, Set<String> retextured) {
        this.model = model;
        this.retextured = retextured;
    }

    public static class Baked
    extends DynamicBakedWrapper<BakedModel> {
        private final Map<ResourceLocation, BakedModel> cache = new ConcurrentHashMap<ResourceLocation, BakedModel>();
        private final IGeometryBakingContext owner;
        private final SimpleBlockModel model;
        private final ModelState transform;
        private final Set<String> retextured;
        private final ItemOverrides overrides = new RetexturedOverride();

        public Baked(BakedModel baked, IGeometryBakingContext owner, SimpleBlockModel model, ModelState transform, Set<String> retextured) {
            super(baked);
            this.model = model;
            this.owner = owner;
            this.transform = transform;
            this.retextured = retextured;
        }

        private BakedModel getRetexturedModel(ResourceLocation name) {
            return this.model.bakeDynamic(new RetexturedContext(this.owner, this.retextured, name), this.transform);
        }

        private BakedModel getCachedModel(Block block) {
            return this.cache.computeIfAbsent(ModelHelper.getParticleTexture(block), this::getRetexturedModel);
        }

        public TextureAtlasSprite getParticleIcon(ModelData data) {
            Block block;
            if (this.retextured.contains("particle") && (block = (Block)data.get(RetexturedHelper.BLOCK_PROPERTY)) != null) {
                return this.getCachedModel(block).getParticleIcon(data);
            }
            return this.originalModel.getParticleIcon(data);
        }

        @Override
        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, RandomSource random, ModelData data, @Nullable RenderType renderType) {
            Block block = (Block)data.get(RetexturedHelper.BLOCK_PROPERTY);
            if (block == null) {
                return this.originalModel.getQuads(state, direction, random, data, null);
            }
            return this.getCachedModel(block).getQuads(state, direction, random, data, null);
        }

        public ItemOverrides m_7343_() {
            return this.overrides;
        }

        private class RetexturedOverride
        extends ItemOverrides {
            private RetexturedOverride() {
            }

            @Nullable
            public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int pSeed) {
                if (stack.m_41619_() || !stack.m_41782_()) {
                    return originalModel;
                }
                Block block = RetexturedBlockItem.getTexture(stack);
                if (block == Blocks.f_50016_) {
                    return originalModel;
                }
                return Baked.this.getCachedModel(block);
            }
        }
    }

    public static class RetexturedContext
    extends GeometryContextWrapper {
        private final Set<String> retextured;
        private final Material texture;

        public RetexturedContext(IGeometryBakingContext base, Set<String> retextured, ResourceLocation texture) {
            super(base);
            this.retextured = retextured;
            this.texture = new Material(InventoryMenu.f_39692_, texture);
        }

        @Override
        public boolean hasMaterial(String name) {
            if (this.retextured.contains(name)) {
                return !MissingTextureAtlasSprite.m_118071_().equals((Object)this.texture.m_119203_());
            }
            return super.hasMaterial(name);
        }

        @Override
        public Material getMaterial(String name) {
            if (this.retextured.contains(name)) {
                return this.texture;
            }
            return super.getMaterial(name);
        }
    }
}

