/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.data;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.ApiStatus;
import slimeknights.mantle.recipe.data.ConsumerWrapperBuilder;
import slimeknights.mantle.registration.object.IdAwareObject;
import slimeknights.mantle.util.IdExtender;

public interface IRecipeHelper
extends IdExtender.LocationExtender {
    public String getModId();

    @Override
    @ApiStatus.Internal
    default public ResourceLocation location(String namespace, String path) {
        return this.location(path);
    }

    default public ResourceLocation location(String name) {
        return new ResourceLocation(this.getModId(), name);
    }

    default public String prefix(String id) {
        return this.getModId() + ":" + id;
    }

    default public ResourceLocation id(ItemLike item) {
        return this.location(Registry.f_122827_.m_7981_((Object)item.m_5456_()).m_135815_());
    }

    default public <T> ResourceLocation id(Registry<T> registry, T value) {
        return this.location(Objects.requireNonNull(registry.m_7981_(value)).m_135815_());
    }

    default public ResourceLocation wrap(RegistryObject<?> location, String prefix, String suffix) {
        return this.wrap(location.getId(), prefix, suffix);
    }

    default public ResourceLocation prefix(RegistryObject<?> location, String prefix) {
        return this.prefix(location.getId(), prefix);
    }

    default public ResourceLocation suffix(RegistryObject<?> location, String suffix) {
        return this.suffix(location.getId(), suffix);
    }

    default public ResourceLocation wrap(IdAwareObject location, String prefix, String suffix) {
        return this.wrap(location.getId(), prefix, suffix);
    }

    default public ResourceLocation prefix(IdAwareObject location, String prefix) {
        return this.prefix(location.getId(), prefix);
    }

    default public ResourceLocation suffix(IdAwareObject location, String suffix) {
        return this.suffix(location.getId(), suffix);
    }

    default public TagKey<Item> getItemTag(String modId, String name) {
        return TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(modId, name));
    }

    default public TagKey<Fluid> getFluidTag(String modId, String name) {
        return TagKey.m_203882_((ResourceKey)Registry.f_122899_, (ResourceLocation)new ResourceLocation(modId, name));
    }

    default public ICondition tagCondition(String name) {
        return new NotCondition((ICondition)new TagEmptyCondition("forge", name));
    }

    default public Consumer<FinishedRecipe> withCondition(Consumer<FinishedRecipe> consumer, ICondition ... conditions) {
        ConsumerWrapperBuilder builder = ConsumerWrapperBuilder.wrap();
        for (ICondition condition : conditions) {
            builder.addCondition(condition);
        }
        return builder.build(consumer);
    }
}

