/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.predicate.damage;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.PredicateRegistry;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;

public interface DamageSourcePredicate
extends IJsonPredicate<DamageSource> {
    public static final DamageSourcePredicate ANY = DamageSourcePredicate.simple(source -> true);
    public static final PredicateRegistry<DamageSource> LOADER = new PredicateRegistry<DamageSource>("Damage Source Predicate", ANY);
    public static final DamageSourcePredicate PROJECTILE = DamageSourcePredicate.simple(DamageSource::m_19360_);
    public static final DamageSourcePredicate EXPLOSION = DamageSourcePredicate.simple(DamageSource::m_19372_);
    public static final DamageSourcePredicate BYPASS_ARMOR = DamageSourcePredicate.simple(DamageSource::m_19376_);
    public static final DamageSourcePredicate DAMAGE_HELMET = DamageSourcePredicate.simple(DamageSource::m_146705_);
    public static final DamageSourcePredicate BYPASS_INVULNERABLE = DamageSourcePredicate.simple(DamageSource::m_19378_);
    public static final DamageSourcePredicate BYPASS_MAGIC = DamageSourcePredicate.simple(DamageSource::m_19379_);
    public static final DamageSourcePredicate BYPASS_ENCHANTMENTS = DamageSourcePredicate.simple(DamageSource::m_238340_);
    public static final DamageSourcePredicate FIRE = DamageSourcePredicate.simple(DamageSource::m_19384_);
    public static final DamageSourcePredicate MAGIC = DamageSourcePredicate.simple(DamageSource::m_19387_);
    public static final DamageSourcePredicate FALL = DamageSourcePredicate.simple(DamageSource::m_146707_);
    public static final DamageSourcePredicate IS_INDIRECT = DamageSourcePredicate.simple(source -> source.m_7639_() != source.m_7640_());
    public static final DamageSourcePredicate HAS_ENTITY = DamageSourcePredicate.simple(source -> source.m_7639_() != null);
    public static final DamageSourcePredicate CAN_PROTECT = DamageSourcePredicate.simple(source -> !source.m_19379_() && !source.m_238340_() && !source.m_19378_());
    public static final DamageSourcePredicate MELEE = DamageSourcePredicate.simple(source -> {
        if (source.m_19360_()) {
            return false;
        }
        if (source.m_7639_() != null) {
            EntityDamageSource entityDamage;
            return source instanceof EntityDamageSource && !(entityDamage = (EntityDamageSource)source).m_19403_();
        }
        return !source.m_19376_() && !source.m_19384_() && !source.m_19387_() && !source.m_19372_();
    });

    @Override
    default public IJsonPredicate<DamageSource> inverted() {
        return LOADER.invert(this);
    }

    public static DamageSourcePredicate simple(final Predicate<DamageSource> predicate) {
        return GenericLoaderRegistry.SingletonLoader.singleton(loader -> new DamageSourcePredicate(){
            final /* synthetic */ GenericLoaderRegistry.IGenericLoader val$loader;
            {
                this.val$loader = iGenericLoader;
            }

            @Override
            public boolean matches(DamageSource source) {
                return predicate.test(source);
            }

            @Override
            public GenericLoaderRegistry.IGenericLoader<? extends DamageSourcePredicate> getLoader() {
                return this.val$loader;
            }
        });
    }

    @SafeVarargs
    public static IJsonPredicate<DamageSource> and(IJsonPredicate<DamageSource> ... predicates) {
        return LOADER.and(List.of(predicates));
    }

    @SafeVarargs
    public static IJsonPredicate<DamageSource> or(IJsonPredicate<DamageSource> ... predicates) {
        return LOADER.or(List.of(predicates));
    }
}

