/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.util.GsonHelper;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.util.JsonHelper;

public abstract class GenericDataProvider
implements DataProvider {
    protected final DataGenerator generator;
    private final PackType type;
    private final String folder;
    private final Gson gson;

    public GenericDataProvider(DataGenerator generator, PackType type, String folder) {
        this(generator, type, folder, JsonHelper.DEFAULT_GSON);
    }

    protected void saveJson(CachedOutput output, ResourceLocation location, Object object, @Nullable Comparator<String> keyComparator) {
        try {
            Path path = this.generator.m_123916_().resolve(Paths.get(this.type.m_10305_(), location.m_135827_(), this.folder, location.m_135815_() + ".json"));
            GenericDataProvider.saveStable(output, this.gson.toJsonTree(object), path, keyComparator);
        }
        catch (IOException e) {
            Mantle.logger.error("Couldn't create data for {}", (Object)location, (Object)e);
        }
    }

    protected void saveJson(CachedOutput output, ResourceLocation location, Object object) {
        this.saveJson(output, location, object, DataProvider.f_236068_);
    }

    protected <T> void saveJson(CachedOutput output, ResourceLocation location, Codec<T> codec, T object) {
        this.saveJson(output, location, codec.encodeStart((DynamicOps)JsonOps.INSTANCE, object).getOrThrow(false, arg_0 -> ((Logger)Mantle.logger).error(arg_0)));
    }

    static void saveStable(CachedOutput cache, JsonElement pJson, Path pPath, @Nullable Comparator<String> keyComparator) throws IOException {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        HashingOutputStream hashingOutput = new HashingOutputStream(Hashing.sha1(), (OutputStream)byteOutput);
        JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)hashingOutput, StandardCharsets.UTF_8));
        writer.setSerializeNulls(false);
        writer.setIndent("  ");
        GsonHelper.m_216207_((JsonWriter)writer, (JsonElement)pJson, keyComparator);
        writer.close();
        cache.m_213871_(pPath, byteOutput.toByteArray(), hashingOutput.hash());
    }

    public GenericDataProvider(DataGenerator generator, PackType type, String folder, Gson gson) {
        this.generator = generator;
        this.type = type;
        this.folder = folder;
        this.gson = gson;
    }
}

