/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.mapping;

import com.google.common.collect.ImmutableCollection;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.loadable.Loadable;

public abstract class CollectionLoadable<T, C extends Collection<T>, B extends ImmutableCollection.Builder<T>>
implements Loadable<C> {
    private final Loadable<T> base;
    private final int minSize;

    protected abstract B makeBuilder();

    protected abstract C build(B var1);

    @Override
    public C convert(JsonElement element, String key) {
        JsonArray array = GsonHelper.m_13924_((JsonElement)element, (String)key);
        if (array.size() < this.minSize) {
            throw new JsonSyntaxException(key + " must have at least " + this.minSize + " elements");
        }
        B builder = this.makeBuilder();
        for (int i = 0; i < array.size(); ++i) {
            builder.add(this.base.convert(array.get(i), key + "[" + i + "]"));
        }
        return this.build(builder);
    }

    public JsonArray serialize(C collection) {
        if (collection.size() < this.minSize) {
            throw new RuntimeException("Collection must have at least " + this.minSize + " elements");
        }
        JsonArray array = new JsonArray();
        for (Object element : collection) {
            array.add(this.base.serialize(element));
        }
        return array;
    }

    @Override
    public C decode(FriendlyByteBuf buffer) {
        B builder = this.makeBuilder();
        int max = buffer.m_130242_();
        for (int i = 0; i < max; ++i) {
            builder.add(this.base.decode(buffer));
        }
        return this.build(builder);
    }

    @Override
    public void encode(FriendlyByteBuf buffer, C collection) {
        buffer.m_130130_(collection.size());
        for (Object element : collection) {
            this.base.encode(buffer, element);
        }
    }

    public CollectionLoadable(Loadable<T> base, int minSize) {
        this.base = base;
        this.minSize = minSize;
    }
}

