/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import slimeknights.mantle.Mantle;

public interface JsonCodec<T>
extends Codec<T> {
    public T deserialize(JsonElement var1);

    public JsonElement serialize(T var1);

    default public String codecError() {
        return this.toString();
    }

    default public <O> DataResult<Pair<T, O>> decode(DynamicOps<O> ops, O input) {
        try {
            return DataResult.success((Object)Pair.of(this.deserialize((JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input)), input));
        }
        catch (JsonParseException e) {
            Mantle.logger.warn("Unable to decode {}", (Object)this.codecError(), (Object)e);
            return DataResult.error((String)e.getMessage());
        }
    }

    default public <O> DataResult<O> encode(T input, DynamicOps<O> ops, O prefix) {
        try {
            return DataResult.success((Object)JsonOps.INSTANCE.convertTo(ops, this.serialize(input)));
        }
        catch (JsonParseException e) {
            Mantle.logger.warn("Unable to encode {}", (Object)this.codecError(), (Object)e);
            return DataResult.error((String)e.getMessage());
        }
    }

    public record GsonCodec<T>(String name, Gson gson, Class<T> classType) implements JsonCodec<T>
    {
        @Override
        public T deserialize(JsonElement element) {
            return (T)this.gson.fromJson(element, this.classType);
        }

        @Override
        public JsonElement serialize(T object) {
            return this.gson.toJsonTree(object, this.classType);
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

