/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.mapping;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public class CompactLoadable<T>
implements Loadable<T> {
    private final Loadable<T> loadable;
    private final Loadable<T> compact;
    private final Predicate<T> compactCondition;

    public static <T> Loadable<T> of(Loadable<T> loadable, Loadable<T> compact, Predicate<T> compactCondition) {
        return new CompactLoadable<T>(loadable, compact, compactCondition);
    }

    public static <T> RecordLoadable<T> of(RecordLoadable<T> loadable, Loadable<T> compact, Predicate<T> compactCondition) {
        return new Record<T>(loadable, compact, compactCondition);
    }

    @Override
    public T convert(JsonElement element, String key) {
        if (element.isJsonPrimitive()) {
            return this.compact.convert(element, key);
        }
        return this.loadable.convert(element, key);
    }

    @Override
    public JsonElement serialize(T object) {
        if (this.compactCondition.test(object)) {
            return this.compact.serialize(object);
        }
        return this.loadable.serialize(object);
    }

    @Override
    public T decode(FriendlyByteBuf buffer) {
        return (T)this.loadable.decode(buffer);
    }

    @Override
    public void encode(FriendlyByteBuf buffer, T object) {
        this.loadable.encode(buffer, object);
    }

    protected CompactLoadable(Loadable<T> loadable, Loadable<T> compact, Predicate<T> compactCondition) {
        this.loadable = loadable;
        this.compact = compact;
        this.compactCondition = compactCondition;
    }

    private static class Record<T>
    extends CompactLoadable<T>
    implements RecordLoadable<T> {
        private final RecordLoadable<T> loadable;

        public Record(RecordLoadable<T> loadable, Loadable<T> compact, Predicate<T> compactCondition) {
            super(loadable, compact, compactCondition);
            this.loadable = loadable;
        }

        @Override
        public T deserialize(JsonObject json, TypedMap context) {
            return this.loadable.deserialize(json, context);
        }

        @Override
        public void serialize(T object, JsonObject json) {
            this.loadable.serialize(object, json);
        }

        @Override
        public T decode(FriendlyByteBuf buffer, TypedMap context) {
            return (T)this.loadable.decode(buffer, context);
        }
    }
}

