/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.registries.MissingMappingsEvent;
import slimeknights.mantle.util.RegistryHelper;

public class RegistrationHelper {
    private static final List<WoodType> WOOD_TYPES = new ArrayList<WoodType>();

    public static <T> T injected() {
        return null;
    }

    public static <T, R extends T> Supplier<R> getCastedHolder(DefaultedRegistry<T> registry, T entry) {
        Supplier holder = RegistryHelper.getHolder(registry, entry);
        return () -> holder.get();
    }

    public static <T> void handleMissingMappings(MissingMappingsEvent event, String modID, ResourceKey<? extends Registry<T>> registry, Function<String, T> handler) {
        for (MissingMappingsEvent.Mapping mapping : event.getAllMappings(registry)) {
            T value;
            ResourceLocation id = mapping.getKey();
            if (!modID.equals(id.m_135827_()) || (value = handler.apply(id.m_135815_())) == null) continue;
            mapping.remap(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerWoodType(WoodType type) {
        List<WoodType> list = WOOD_TYPES;
        synchronized (list) {
            WOOD_TYPES.add(type);
            WoodType.m_61844_((WoodType)type);
        }
    }

    public static void forEachWoodType(Consumer<WoodType> consumer) {
        WOOD_TYPES.forEach(consumer);
    }

    private RegistrationHelper() {
    }
}

