/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.loot.function;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.loot.MantleLoot;
import slimeknights.mantle.recipe.helper.RecipeHelper;

public class SetFluidLootFunction
extends LootItemConditionalFunction {
    public static final Serializer SERIALIZER = new Serializer();
    private final FluidStack fluid;

    protected SetFluidLootFunction(LootItemCondition[] conditionsIn, FluidStack fluid) {
        super(conditionsIn);
        this.fluid = fluid;
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(handler -> {
            handler.fill(this.fluid.copy(), IFluidHandler.FluidAction.EXECUTE);
            return handler.getContainer();
        }).orElse(stack);
    }

    public LootItemFunctionType m_7162_() {
        return MantleLoot.SET_FLUID_FUNCTION;
    }

    public static LootItemConditionalFunction.Builder<?> builder(FluidStack fluid) {
        return SetFluidLootFunction.m_80683_(conditions -> new SetFluidLootFunction((LootItemCondition[])conditions, fluid));
    }

    private static class Serializer
    extends LootItemConditionalFunction.Serializer<SetFluidLootFunction> {
        private Serializer() {
        }

        public void serialize(JsonObject json, SetFluidLootFunction loot, JsonSerializationContext context) {
            super.m_6170_(json, (LootItemConditionalFunction)loot, context);
            json.add("fluid", (JsonElement)RecipeHelper.serializeFluidStack(loot.fluid));
        }

        public SetFluidLootFunction deserialize(JsonObject object, JsonDeserializationContext context, LootItemCondition[] conditions) {
            FluidStack fluid = RecipeHelper.deserializeFluidStack(GsonHelper.m_13930_((JsonObject)object, (String)"fluid"));
            return new SetFluidLootFunction(conditions, fluid);
        }
    }
}

