/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.mapping;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.mapping.CollectionLoadable;

public class AnyCollectionLoadable<T>
extends CollectionLoadable<T, Collection<T>, ImmutableCollection.Builder<T>> {
    private final Supplier<ImmutableCollection.Builder<T>> builder;

    public AnyCollectionLoadable(Loadable<T> base, int minSize, Supplier<ImmutableCollection.Builder<T>> builder) {
        super(base, minSize);
        this.builder = builder;
    }

    public static <T> AnyCollectionLoadable<T> listBacked(Loadable<T> base, int minSize) {
        return new AnyCollectionLoadable<T>(base, minSize, ImmutableList::builder);
    }

    public static <T> AnyCollectionLoadable<T> setBacked(Loadable<T> base, int minSize) {
        return new AnyCollectionLoadable<T>(base, minSize, ImmutableSet::builder);
    }

    @Override
    protected ImmutableCollection.Builder<T> makeBuilder() {
        return this.builder.get();
    }

    @Override
    protected Collection<T> build(ImmutableCollection.Builder<T> builder) {
        return builder.build();
    }

    public <K> Loadable<Map<K, T>> mapWithKeys(Function<T, K> keyGetter) {
        return this.flatXmap(collection -> collection.stream().collect(Collectors.toUnmodifiableMap(keyGetter, Function.identity())), Map::values);
    }

    public <V> Loadable<Map<T, V>> mapWithValues(Function<T, V> valueGetter) {
        return this.flatXmap(collection -> collection.stream().collect(Collectors.toUnmodifiableMap(Function.identity(), valueGetter)), Map::keySet);
    }
}

