/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.data.listener.ISafeManagerReloadListener;
import slimeknights.mantle.util.JsonHelper;

public class ResourceColorManager
implements ISafeManagerReloadListener {
    private static final Logger log = LogManager.getLogger(ResourceColorManager.class);
    private static final String COLORS_PATH = "mantle/colors.json";
    @Deprecated(forRemoval=true)
    private static final String FALLBACK_PATH = "tinkering/colors.json";
    public static final TextColor WHITE = TextColor.m_131266_((int)-1);
    public static final ResourceColorManager INSTANCE = new ResourceColorManager();
    private static Map<String, TextColor> COLORS = Collections.emptyMap();

    public static void init(RegisterClientReloadListenersEvent manager) {
        manager.registerReloadListener((PreparableReloadListener)INSTANCE);
    }

    private static void parseRecursive(String prefix, JsonObject json, Map<String, TextColor> colors) {
        for (Map.Entry entry : json.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if (element.isJsonObject()) {
                ResourceColorManager.parseRecursive(prefix + key + ".", element.getAsJsonObject(), colors);
                continue;
            }
            if (element.isJsonPrimitive()) {
                String fullPath = prefix + key;
                if (colors.containsKey(fullPath)) continue;
                String text = element.getAsString();
                TextColor color = TextColor.m_131268_((String)text);
                if (color == null) {
                    log.error("Color at key '{}' could not be parsed, got '{}'", (Object)fullPath, (Object)text);
                    continue;
                }
                colors.put(fullPath, color);
                continue;
            }
            if (element.isJsonNull()) continue;
            log.error("Skipping color key '{}' as the value is not a string", (Object)key);
        }
    }

    @Override
    public void onReloadSafe(ResourceManager manager) {
        int i;
        HashMap<String, TextColor> colors = new HashMap<String, TextColor>();
        List<JsonObject> jsonFiles = JsonHelper.getFileInAllDomainsAndPacks(manager, COLORS_PATH, null);
        for (i = jsonFiles.size() - 1; i >= 0; --i) {
            ResourceColorManager.parseRecursive("", jsonFiles.get(i), colors);
        }
        jsonFiles = JsonHelper.getFileInAllDomainsAndPacks(manager, FALLBACK_PATH, COLORS_PATH);
        for (i = jsonFiles.size() - 1; i >= 0; --i) {
            ResourceColorManager.parseRecursive("", jsonFiles.get(i), colors);
        }
        COLORS = colors;
    }

    @Nullable
    public static TextColor getOrNull(String path) {
        return COLORS.get(path);
    }

    public static TextColor getTextColor(String path) {
        return COLORS.getOrDefault(path, WHITE);
    }

    public static int getColor(String path) {
        return ResourceColorManager.getTextColor(path).m_131265_();
    }

    private ResourceColorManager() {
    }
}

