/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fluid.texture;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.fluid.texture.FluidTexture;
import slimeknights.mantle.util.JsonHelper;

public class FluidTextureManager
implements Consumer<TextureStitchEvent.Pre> {
    public static final String FOLDER = "mantle/fluid_texture";
    private static final FluidTextureManager INSTANCE = new FluidTextureManager();
    private Map<FluidType, FluidTexture> textures = Collections.emptyMap();
    private static final FluidTexture FALLBACK = new FluidTexture(new ResourceLocation("block/water_still"), new ResourceLocation("block/water_flow"), null, null, -1);

    public static void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.NORMAL, false, TextureStitchEvent.Pre.class, (Consumer)INSTANCE);
    }

    @Override
    public void accept(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_().equals((Object)TextureAtlas.f_118259_)) {
            long time = System.nanoTime();
            HashMap<FluidType, FluidTexture> map = new HashMap<FluidType, FluidTexture>();
            ResourceManager manager = Minecraft.m_91087_().m_91098_();
            IForgeRegistry fluidTypeRegistry = (IForgeRegistry)ForgeRegistries.FLUID_TYPES.get();
            for (Map.Entry entry : manager.m_214159_(FOLDER, location -> location.m_135815_().endsWith(".json")).entrySet()) {
                ResourceLocation fullPath = (ResourceLocation)entry.getKey();
                String path = fullPath.m_135815_();
                ResourceLocation id = JsonHelper.localize(fullPath, FOLDER, ".json");
                try {
                    BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                    try {
                        FluidType type = (FluidType)fluidTypeRegistry.getValue(id);
                        if (type == null || !id.equals((Object)fluidTypeRegistry.getKey((Object)type))) {
                            Mantle.logger.debug("Ignoring fluid texture {} from {} as no fluid type exists with that name", (Object)id, (Object)fullPath);
                            continue;
                        }
                        JsonObject json = (JsonObject)GsonHelper.m_13776_((Gson)JsonHelper.DEFAULT_GSON, (Reader)reader, JsonObject.class);
                        if (json == null) {
                            Mantle.logger.warn("Couldn't load fluid texture file {} from {} as it's null or empty", (Object)id, (Object)fullPath);
                            continue;
                        }
                        map.put(type, FluidTexture.deserialize(json));
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (JsonParseException | IOException | IllegalArgumentException e) {
                    Mantle.logger.error("Couldn't parse fluid texture {} from {}", (Object)id, (Object)fullPath, (Object)e);
                }
            }
            this.textures = map;
            for (FluidTexture texture : map.values()) {
                event.addSprite(texture.still());
                event.addSprite(texture.flowing());
                ResourceLocation overlay = texture.overlay();
                if (overlay == null) continue;
                event.addSprite(overlay);
            }
            Mantle.logger.info("Loaded {} fluid textures in {} ms", (Object)map.size(), (Object)Float.valueOf((float)(System.nanoTime() - time) / 1000000.0f));
        }
    }

    public static FluidTexture getData(FluidType fluid) {
        return FluidTextureManager.INSTANCE.textures.getOrDefault(fluid, FALLBACK);
    }

    public static ResourceLocation getStillTexture(FluidType fluid) {
        return FluidTextureManager.getData(fluid).still();
    }

    public static ResourceLocation getFlowingTexture(FluidType fluid) {
        return FluidTextureManager.getData(fluid).flowing();
    }

    @Nullable
    public static ResourceLocation getOverlayTexture(FluidType fluid) {
        return FluidTextureManager.getData(fluid).overlay();
    }

    @Nullable
    public static ResourceLocation getCameraTexture(FluidType fluid) {
        return FluidTextureManager.getData(fluid).camera();
    }

    public static int getColor(FluidType fluid) {
        return FluidTextureManager.getData(fluid).color();
    }
}

