/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.predicate;

import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.tags.TagKey;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.PredicateRegistry;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;

public class RegistryPredicateRegistry<R, T>
extends PredicateRegistry<T> {
    private final Function<T, R> getter;
    private final BiPredicate<TagKey<R>, T> tagMatcher;
    private final RecordLoadable<SetPredicate> setLoader;
    private final RecordLoadable<TagPredicate> tagLoader;

    public RegistryPredicateRegistry(String name, IJsonPredicate<T> defaultInstance, Loadable<R> registry, Function<T, R> getter, String setKey, Loadable<TagKey<R>> tagKey, BiPredicate<TagKey<R>, T> tagMatcher) {
        super(name, defaultInstance);
        this.getter = getter;
        this.tagMatcher = tagMatcher;
        this.setLoader = RecordLoadable.create(registry.set().requiredField(setKey, p -> p.set), x$0 -> new SetPredicate(x$0));
        this.tagLoader = RecordLoadable.create(tagKey.requiredField("tag", p -> p.tag), x$0 -> new TagPredicate(x$0));
        this.register(Mantle.getResource("set"), this.setLoader);
        this.register(Mantle.getResource("tag"), this.tagLoader);
    }

    public IJsonPredicate<T> setOf(Set<R> values) {
        return new SetPredicate(values);
    }

    public IJsonPredicate<T> tag(TagKey<R> tag) {
        return new TagPredicate(tag);
    }

    private class SetPredicate
    implements IJsonPredicate<T> {
        private final Set<R> set;

        @Override
        public boolean matches(T input) {
            return this.set.contains(RegistryPredicateRegistry.this.getter.apply(input));
        }

        @Override
        public IJsonPredicate<T> inverted() {
            return RegistryPredicateRegistry.this.invert(this);
        }

        @Override
        public GenericLoaderRegistry.IGenericLoader<? extends IJsonPredicate<T>> getLoader() {
            return RegistryPredicateRegistry.this.setLoader;
        }

        public SetPredicate(Set<R> set) {
            this.set = set;
        }
    }

    private class TagPredicate
    implements IJsonPredicate<T> {
        private final TagKey<R> tag;

        @Override
        public boolean matches(T input) {
            return RegistryPredicateRegistry.this.tagMatcher.test(this.tag, (TagKey)input);
        }

        @Override
        public IJsonPredicate<T> inverted() {
            return RegistryPredicateRegistry.this.invert(this);
        }

        @Override
        public GenericLoaderRegistry.IGenericLoader<? extends IJsonPredicate<T>> getLoader() {
            return RegistryPredicateRegistry.this.tagLoader;
        }

        public TagPredicate(TagKey<R> tag) {
            this.tag = tag;
        }
    }
}

