/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.screen.book.ArrowButton;
import slimeknights.mantle.client.screen.book.ILayerRenderFunction;
import slimeknights.mantle.client.screen.book.element.BookElement;

public class BookScreen
extends Screen {
    public static boolean debug = false;
    public static final int TEX_SIZE = 512;
    public static final int PAGE_MARGIN = 8;
    public static final int PAGE_PADDING_TOP = 4;
    public static final int PAGE_PADDING_BOT = 4;
    public static final int PAGE_PADDING_LEFT = 8;
    public static final int PAGE_PADDING_RIGHT = 0;
    public static final float PAGE_SCALE = 1.0f;
    public static final int PAGE_WIDTH_UNSCALED = 206;
    public static final int PAGE_HEIGHT_UNSCALED = 200;
    public static final int PAGE_WIDTH = 182;
    public static final int PAGE_HEIGHT = 176;
    private ArrowButton previousArrow;
    private ArrowButton nextArrow;
    private ArrowButton backArrow;
    private ArrowButton indexArrow;
    public boolean drawArrows = true;
    public boolean mouseInput = true;
    public final BookData book;
    @Nullable
    private final Consumer<String> pageUpdater;
    @Nullable
    private final Consumer<?> bookPickup;
    private int page = -1;
    private int oldPage = -2;
    private final ArrayList<BookElement> leftElements = new ArrayList();
    private final ArrayList<BookElement> rightElements = new ArrayList();
    public AdvancementCache advancementCache;
    private double[] lastClick;
    private double[] lastDrag;
    private static final ILayerRenderFunction[] LAYERS = new ILayerRenderFunction[]{BookElement::draw, BookElement::drawOverlay};

    public BookScreen(Component title, BookData book, String page, @Nullable Consumer<String> pageUpdater, @Nullable Consumer<?> bookPickup) {
        super(title);
        this.book = book;
        this.pageUpdater = pageUpdater;
        this.bookPickup = bookPickup;
        this.f_96541_ = Minecraft.m_91087_();
        this.f_96547_ = this.f_96541_.f_91062_;
        this.advancementCache = new AdvancementCache();
        if (this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.f_108617_.m_105145_().m_104397_((ClientAdvancements.Listener)this.advancementCache);
        }
        this.openPage(book.findPageNumber(page, this.advancementCache));
    }

    public Font getFontRenderer() {
        Font fontRenderer = this.book.fontRenderer;
        if (fontRenderer == null) {
            fontRenderer = Objects.requireNonNull(this.f_96541_).f_91062_;
        }
        return fontRenderer;
    }

    private Vector3f splitRGB(int color) {
        float r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        return new Vector3f(r, g, b);
    }

    private Vector4f splitRGBA(int color) {
        float r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        float a = (float)FastColor.ARGB32.m_13655_((int)color) / 255.0f;
        return new Vector4f(r, g, b, a);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.f_96541_ == null) {
            return;
        }
        Font fontRenderer = this.getFontRenderer();
        if (debug) {
            int n = fontRenderer.m_92895_("DEBUG") + 4;
            Objects.requireNonNull(fontRenderer);
            BookScreen.m_93172_((PoseStack)matrixStack, (int)0, (int)0, (int)n, (int)(9 + 4), (int)0x55000000);
            fontRenderer.m_92883_(matrixStack, "DEBUG", 2.0f, 2.0f, -1);
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_69478_();
        Vector3f coverColor = this.splitRGB(this.book.appearance.coverColor);
        if (this.page == -1) {
            this.renderCover(matrixStack, coverColor);
        } else {
            PoseStack leftMatrix = new PoseStack();
            leftMatrix.m_85850_().m_85861_().m_27644_(matrixStack.m_85850_().m_85861_());
            leftMatrix.m_85850_().m_85864_().m_8178_(matrixStack.m_85850_().m_85864_());
            PoseStack rightMatrix = new PoseStack();
            rightMatrix.m_85850_().m_85861_().m_27644_(matrixStack.m_85850_().m_85861_());
            rightMatrix.m_85850_().m_85864_().m_8178_(matrixStack.m_85850_().m_85864_());
            this.drawerTransform(leftMatrix, false);
            this.drawerTransform(rightMatrix, true);
            leftMatrix.m_85841_(1.0f, 1.0f, 1.0f);
            rightMatrix.m_85841_(1.0f, 1.0f, 1.0f);
            boolean renderLeft = this.shouldRenderPage(this.page, false);
            boolean renderRight = this.shouldRenderPage(this.page, true);
            this.renderUnderLayer(matrixStack, coverColor);
            if (renderLeft) {
                this.renderPageBackground(matrixStack, false);
            }
            if (renderRight) {
                this.renderPageBackground(matrixStack, true);
            }
            int leftMX = this.getMouseX(false);
            int rightMX = this.getMouseX(true);
            int mY = this.getMouseY();
            for (ILayerRenderFunction layer : LAYERS) {
                if (renderLeft) {
                    this.renderPageLayer(leftMatrix, leftMX, mY, partialTicks, this.leftElements, layer);
                }
                if (!renderRight) continue;
                this.renderPageLayer(rightMatrix, rightMX, mY, partialTicks, this.rightElements, layer);
            }
        }
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    private boolean shouldRenderPage(int pageNum, boolean rightSide) {
        if (!rightSide) {
            return pageNum != 0;
        }
        int fullPageCount = this.book.getFullPageCount(this.advancementCache);
        return this.page < fullPageCount - 1 || this.book.getPageCount(this.advancementCache) % 2 != 0;
    }

    private void renderCover(PoseStack matrixStack, Vector3f coverColor) {
        float scale;
        int width;
        Font fontRenderer = this.getFontRenderer();
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.book.appearance.getCoverTexture());
        int centerX = this.f_96543_ / 2 - 103;
        int centerY = this.f_96544_ / 2 - 100;
        RenderSystem.m_157429_((float)coverColor.m_122239_(), (float)coverColor.m_122260_(), (float)coverColor.m_122269_(), (float)1.0f);
        BookScreen.m_93133_((PoseStack)matrixStack, (int)centerX, (int)centerY, (float)0.0f, (float)0.0f, (int)206, (int)200, (int)512, (int)512);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!this.book.appearance.title.isEmpty()) {
            BookScreen.m_93133_((PoseStack)matrixStack, (int)centerX, (int)centerY, (float)0.0f, (float)200.0f, (int)206, (int)200, (int)512, (int)512);
            matrixStack.m_85836_();
            width = fontRenderer.m_92895_(this.book.appearance.title);
            scale = Mth.m_14036_((float)(182.0f / (float)width), (float)0.0f, (float)2.5f);
            matrixStack.m_85841_(scale, scale, 1.0f);
            String string = this.book.appearance.title;
            float f = (float)this.f_96543_ / 2.0f / scale + 3.0f - (float)width / 2.0f;
            float f2 = (float)this.f_96544_ / 2.0f;
            Objects.requireNonNull(fontRenderer);
            fontRenderer.m_92750_(matrixStack, string, f, (f2 - 9.0f / 2.0f) / scale - 4.0f, this.book.appearance.getCoverTextColor());
            matrixStack.m_85849_();
        }
        if (!this.book.appearance.subtitle.isEmpty()) {
            matrixStack.m_85836_();
            width = fontRenderer.m_92895_(this.book.appearance.subtitle);
            scale = Mth.m_14036_((float)(182.0f / (float)width), (float)0.0f, (float)1.5f);
            matrixStack.m_85841_(scale, scale, 1.0f);
            String string = this.book.appearance.subtitle;
            float f = (float)this.f_96543_ / 2.0f / scale + 7.0f - (float)width / 2.0f;
            float f3 = (float)this.f_96544_ / 2.0f + 100.0f;
            Objects.requireNonNull(fontRenderer);
            fontRenderer.m_92750_(matrixStack, string, f, (f3 - (float)(9 * 2)) / scale, this.book.appearance.getCoverTextColor());
            matrixStack.m_85849_();
        }
    }

    private void renderUnderLayer(PoseStack matrixStack, Vector3f coverColor) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.book.appearance.getBookTexture());
        RenderSystem.m_157429_((float)coverColor.m_122239_(), (float)coverColor.m_122260_(), (float)coverColor.m_122269_(), (float)1.0f);
        BookScreen.m_93133_((PoseStack)matrixStack, (int)(this.f_96543_ / 2 - 206), (int)(this.f_96544_ / 2 - 100), (float)0.0f, (float)0.0f, (int)412, (int)200, (int)512, (int)512);
    }

    private void renderPageBackground(PoseStack matrixStack, boolean rightSide) {
        Vector3f pageTint = this.splitRGB(this.book.appearance.getPageTint());
        RenderSystem.m_157429_((float)pageTint.m_122239_(), (float)pageTint.m_122260_(), (float)pageTint.m_122269_(), (float)1.0f);
        if (!rightSide) {
            BookScreen.m_93133_((PoseStack)matrixStack, (int)(this.f_96543_ / 2 - 206), (int)(this.f_96544_ / 2 - 100), (float)0.0f, (float)200.0f, (int)206, (int)200, (int)512, (int)512);
        } else {
            BookScreen.m_93133_((PoseStack)matrixStack, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 100), (float)206.0f, (float)200.0f, (int)206, (int)200, (int)512, (int)512);
        }
    }

    private void renderPageLayer(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks, List<BookElement> elements, ILayerRenderFunction layerFunc) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.book.appearance.getCoverTexture());
        Font font = this.getFontRenderer();
        for (BookElement element : elements) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            layerFunc.draw(element, matrixStack, mouseX, mouseY, partialTicks, font);
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        this.previousArrow = (ArrowButton)this.m_142416_((GuiEventListener)new ArrowButton(this.book, 50, -50, ArrowButton.ArrowType.PREV, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover, p_212998_1_ -> {
            --this.page;
            if (this.page < -1) {
                this.page = -1;
            }
            this.oldPage = -2;
            this.buildPages();
        }));
        this.nextArrow = (ArrowButton)this.m_142416_((GuiEventListener)new ArrowButton(this.book, -50, -50, ArrowButton.ArrowType.NEXT, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover, p_212998_1_ -> {
            ++this.page;
            int fullPageCount = this.book.getFullPageCount(this.advancementCache);
            if (this.page >= fullPageCount) {
                this.page = fullPageCount - 1;
            }
            this.oldPage = -2;
            this.buildPages();
        }));
        this.backArrow = (ArrowButton)this.m_142416_((GuiEventListener)new ArrowButton(this.book, this.f_96543_ / 2 - 9, this.f_96544_ / 2 + 5 + 88, ArrowButton.ArrowType.LEFT, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover, p_212998_1_ -> {
            if (this.oldPage >= -1) {
                this.page = this.oldPage;
            }
            this.oldPage = -2;
            this.buildPages();
        }));
        this.indexArrow = (ArrowButton)this.m_142416_((GuiEventListener)new ArrowButton(this.book, this.f_96543_ / 2 - 206 - 9, this.f_96544_ / 2 - 100, ArrowButton.ArrowType.BACK_UP, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover, p_212998_1_ -> {
            this.openPage(this.book.findPageNumber("index.page1", this.advancementCache));
            this.oldPage = -2;
            this.buildPages();
        }));
        if (this.bookPickup != null) {
            int margin = 10;
            if (this.f_96544_ / 2 + 100 + margin + 20 >= this.f_96544_) {
                margin = 0;
            }
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 98, this.f_96544_ / 2 + 100 + margin, 196, 20, (Component)Component.m_237115_((String)"lectern.take_book"), p_212998_1_ -> {
                this.m_7379_();
                this.bookPickup.accept(null);
            }));
        }
        this.buildPages();
    }

    public void m_86600_() {
        super.m_86600_();
        this.previousArrow.f_93624_ = this.page != -1 && this.drawArrows;
        this.nextArrow.f_93624_ = this.page + 1 < this.book.getFullPageCount(this.advancementCache) && this.drawArrows;
        boolean bl = this.backArrow.f_93624_ = this.oldPage >= -1 && this.drawArrows;
        if (this.page == -1) {
            this.nextArrow.f_93620_ = this.f_96543_ / 2 + 80;
            this.indexArrow.f_93624_ = false;
        } else {
            this.previousArrow.f_93620_ = this.f_96543_ / 2 - 184;
            this.nextArrow.f_93620_ = this.f_96543_ / 2 + 165;
            SectionData index = this.book.findSection("index", this.advancementCache);
            this.indexArrow.f_93624_ = index != null && (this.page - 1) * 2 + 2 > index.getPageCount() && this.drawArrows;
        }
        this.previousArrow.f_93621_ = this.f_96544_ / 2 + 75;
        this.nextArrow.f_93621_ = this.f_96544_ / 2 + 75;
    }

    public boolean previousPage() {
        --this.page;
        if (this.page < -1) {
            this.page = -1;
            return false;
        }
        this.oldPage = -2;
        this.buildPages();
        return true;
    }

    public boolean nextPage() {
        ++this.page;
        int fullPageCount = this.book.getFullPageCount(this.advancementCache);
        if (this.page >= fullPageCount) {
            this.page = fullPageCount - 1;
            return false;
        }
        this.oldPage = -2;
        this.buildPages();
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        super.m_7933_(keyCode, scanCode, modifiers);
        switch (keyCode) {
            case 65: 
            case 263: {
                this.previousPage();
                return true;
            }
            case 68: 
            case 262: {
                this.nextPage();
                return true;
            }
            case 292: {
                debug = !debug;
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6050_(double unKnown1, double unKnown2, double scrollDelta) {
        if (scrollDelta < 0.0) {
            this.nextPage();
            return true;
        }
        if (scrollDelta > 0.0) {
            this.previousPage();
            return true;
        }
        return super.m_6050_(scrollDelta, unKnown1, unKnown2);
    }

    public boolean m_6375_(double originalMouseX, double originalMouseY, int mouseButton) {
        boolean right = false;
        double mouseX = this.getMouseX(false);
        double mouseY = this.getMouseY();
        if (mouseX > 198.0) {
            mouseX = this.getMouseX(true);
            right = true;
        }
        this.lastClick = new double[]{mouseX, mouseY};
        int oldPage = this.page;
        ImmutableList elementList = ImmutableList.copyOf(right ? this.rightElements : this.leftElements);
        for (BookElement element : elementList) {
            element.mouseClicked(mouseX, mouseY, mouseButton);
            if (this.page == oldPage) continue;
            return true;
        }
        return super.m_6375_(originalMouseX, originalMouseY, mouseButton);
    }

    public boolean m_6348_(double originalMouseX, double originalMouseY, int mouseButton) {
        boolean right = false;
        double mouseX = this.getMouseX(false);
        double mouseY = this.getMouseY();
        if (mouseX > 198.0) {
            mouseX = this.getMouseX(true);
            right = true;
        }
        int i = 0;
        while (right ? i < this.rightElements.size() : i < this.leftElements.size()) {
            BookElement element = right ? this.rightElements.get(i) : this.leftElements.get(i);
            element.mouseReleased(mouseX, mouseY, mouseButton);
            ++i;
        }
        this.lastClick = null;
        this.lastDrag = null;
        return super.m_6348_(originalMouseX, originalMouseY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        boolean right = false;
        mouseX = this.getMouseX(false);
        mouseY = this.getMouseY();
        if (mouseX > 198.0) {
            mouseX = this.getMouseX(true);
            right = true;
        }
        if (this.lastClick != null) {
            if (this.lastDrag == null) {
                this.lastDrag = new double[]{mouseX, mouseY};
            }
            int i = 0;
            while (right ? i < this.rightElements.size() : i < this.leftElements.size()) {
                BookElement element = right ? this.rightElements.get(i) : this.leftElements.get(i);
                element.mouseDragged(this.lastClick[0], this.lastClick[1], mouseX, mouseY, this.lastDrag[0], this.lastDrag[1], button);
                ++i;
            }
            this.lastDrag = new double[]{mouseX, mouseY};
        }
        return true;
    }

    public void m_7861_() {
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return;
        }
        if (this.pageUpdater != null) {
            Object pageStr = "";
            if (this.page >= 0) {
                PageData page;
                PageData pageData = page = this.page == 0 ? this.book.findPage(0, this.advancementCache) : this.book.findPage((this.page - 1) * 2 + 1, this.advancementCache);
                if (page == null) {
                    page = this.book.findPage((this.page - 1) * 2 + 2, this.advancementCache);
                }
                if (page != null && page.parent != null) {
                    pageStr = page.parent.name + "." + page.name;
                }
            }
            this.pageUpdater.accept((String)pageStr);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void drawerTransform(PoseStack matrixStack, boolean rightSide) {
        if (rightSide) {
            matrixStack.m_85837_((double)(this.f_96543_ / 2 + 0 + 8), (double)(this.f_96544_ / 2 - 100 + 4 + 8), 0.0);
        } else {
            matrixStack.m_85837_((double)(this.f_96543_ / 2 - 206 + 8 + 8), (double)(this.f_96544_ / 2 - 100 + 4 + 8), 0.0);
        }
    }

    protected float leftOffset(boolean rightSide) {
        if (rightSide) {
            return this.f_96543_ / 2 + 0 + 8;
        }
        return this.f_96543_ / 2 - 206 + 8 + 8;
    }

    protected float topOffset() {
        return this.f_96544_ / 2 - 100 + 4 + 8;
    }

    protected int getMouseX(boolean rightSide) {
        assert (this.f_96541_ != null);
        if (!this.mouseInput) {
            return -1;
        }
        return (int)((Minecraft.m_91087_().f_91067_.m_91589_() * (double)this.f_96543_ / (double)this.f_96541_.m_91268_().m_85443_() - (double)this.leftOffset(rightSide)) / 1.0);
    }

    protected int getMouseY() {
        assert (this.f_96541_ != null);
        if (!this.mouseInput) {
            return -1;
        }
        return (int)((Minecraft.m_91087_().f_91067_.m_91594_() * (double)this.f_96544_ / (double)this.f_96541_.m_91268_().m_85444_() - 1.0 - (double)this.topOffset()) / 1.0);
    }

    public int openPage(int page) {
        return this.openPage(page, false);
    }

    public int openPage(int page, boolean returner) {
        if (page < 0) {
            return -1;
        }
        int bookPage = page == 1 ? 0 : (page % 2 == 0 ? (page - 1) / 2 + 1 : (page - 2) / 2 + 1);
        if (bookPage >= -1 && bookPage < this.book.getFullPageCount(this.advancementCache)) {
            if (returner) {
                this.oldPage = this.page;
            }
            this._setPage(bookPage);
        }
        return page % 2 == 0 ? 0 : 1;
    }

    public void _setPage(int page) {
        this.page = page;
        this.buildPages();
    }

    public int getPage(int side) {
        if (this.page == 0 && side == 0) {
            return -1;
        }
        if (this.page == 0 && side == 1) {
            return 0;
        }
        if (side == 0) {
            return (this.page - 1) * 2 + 1;
        }
        if (side == 1) {
            return (this.page - 2) * 2 + 2;
        }
        return -1;
    }

    public int getPage_() {
        return this.page;
    }

    public List<BookElement> getElements(int side) {
        return side == 0 ? this.leftElements : (side == 1 ? this.rightElements : Collections.emptyList());
    }

    public void openCover() {
        this._setPage(-1);
        this.leftElements.clear();
        this.rightElements.clear();
        this.buildPages();
    }

    private void buildPages() {
        this.leftElements.clear();
        this.rightElements.clear();
        if (this.page == -1) {
            return;
        }
        if (this.page == 0) {
            PageData page = this.book.findPage(0, this.advancementCache);
            if (page != null) {
                page.content.build(this.book, this.rightElements, false);
            }
        } else {
            PageData leftPage = this.book.findPage((this.page - 1) * 2 + 1, this.advancementCache);
            PageData rightPage = this.book.findPage((this.page - 1) * 2 + 2, this.advancementCache);
            if (leftPage != null) {
                leftPage.content.build(this.book, this.leftElements, false);
            }
            if (rightPage != null) {
                rightPage.content.build(this.book, this.rightElements, true);
            }
        }
        for (BookElement element : this.leftElements) {
            element.parent = this;
        }
        for (BookElement element : this.rightElements) {
            element.parent = this;
        }
    }

    public static class AdvancementCache
    implements ClientAdvancements.Listener {
        private final HashMap<Advancement, AdvancementProgress> progress = new HashMap();
        private final HashMap<ResourceLocation, Advancement> nameCache = new HashMap();

        @Nullable
        public AdvancementProgress getProgress(String id) {
            return this.getProgress(this.getAdvancement(id));
        }

        @Nullable
        public AdvancementProgress getProgress(Advancement advancement) {
            return this.progress.get(advancement);
        }

        public Advancement getAdvancement(String id) {
            return this.nameCache.get(new ResourceLocation(id));
        }

        public void m_7922_(Advancement advancement, AdvancementProgress advancementProgress) {
            this.progress.put(advancement, advancementProgress);
        }

        public void m_6896_(@Nullable Advancement advancement) {
        }

        public void m_5513_(Advancement advancement) {
            this.nameCache.put(advancement.m_138327_(), advancement);
        }

        public void m_5504_(Advancement advancement) {
            this.progress.remove(advancement);
            this.nameCache.remove(advancement.m_138327_());
        }

        public void m_5505_(Advancement advancement) {
            this.nameCache.put(advancement.m_138327_(), advancement);
        }

        public void m_5516_(Advancement advancement) {
            this.progress.remove(advancement);
            this.nameCache.remove(advancement.m_138327_());
        }

        public void m_7204_() {
            this.progress.clear();
            this.nameCache.clear();
        }
    }
}

