/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable;

import java.util.function.BiFunction;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ToolAction;
import slimeknights.mantle.data.loadable.ErrorFactory;
import slimeknights.mantle.data.loadable.common.RegistryLoadable;
import slimeknights.mantle.data.loadable.primitive.ResourceLocationLoadable;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;

public class Loadables {
    public static final StringLoadable<ResourceLocation> RESOURCE_LOCATION = StringLoadable.DEFAULT.xmap((s, e) -> {
        try {
            return new ResourceLocation(s);
        }
        catch (ResourceLocationException ex) {
            throw e.create((RuntimeException)((Object)ex));
        }
    }, (r, e) -> r.toString());
    public static final StringLoadable<ToolAction> TOOL_ACTION = StringLoadable.DEFAULT.flatXmap(ToolAction::get, ToolAction::name);
    public static final ResourceLocationLoadable<SoundEvent> SOUND_EVENT = new RegistryLoadable<SoundEvent>(Registry.f_122821_);
    public static final ResourceLocationLoadable<Fluid> FLUID = new RegistryLoadable<Fluid>((Registry<Fluid>)Registry.f_122822_);
    public static final ResourceLocationLoadable<MobEffect> MOB_EFFECT = new RegistryLoadable<MobEffect>(Registry.f_122823_);
    public static final ResourceLocationLoadable<Block> BLOCK = new RegistryLoadable<Block>((Registry<Block>)Registry.f_122824_);
    public static final ResourceLocationLoadable<Enchantment> ENCHANTMENT = new RegistryLoadable<Enchantment>(Registry.f_122825_);
    public static final ResourceLocationLoadable<EntityType<?>> ENTITY_TYPE = new RegistryLoadable((Registry<EntityType<?>>)Registry.f_122826_);
    public static final ResourceLocationLoadable<Item> ITEM = new RegistryLoadable<Item>((Registry<Item>)Registry.f_122827_);
    public static final ResourceLocationLoadable<Potion> POTION = new RegistryLoadable<Potion>((Registry<Potion>)Registry.f_122828_);
    public static final ResourceLocationLoadable<ParticleType<?>> PARTICLE_TYPE = new RegistryLoadable(Registry.f_122829_);
    public static final ResourceLocationLoadable<BlockEntityType<?>> BLOCK_ENTITY_TYPE = new RegistryLoadable(Registry.f_122830_);
    public static final ResourceLocationLoadable<Attribute> ATTRIBUTE = new RegistryLoadable<Attribute>(Registry.f_122866_);
    public static final StringLoadable<Fluid> NON_EMPTY_FLUID = Loadables.notValue(FLUID, Fluids.f_76191_, "Fluid cannot be empty");
    public static final StringLoadable<Block> NON_EMPTY_BLOCK = Loadables.notValue(BLOCK, Blocks.f_50016_, "Block cannot be air");
    public static final StringLoadable<Item> NON_EMPTY_ITEM = Loadables.notValue(ITEM, Items.f_41852_, "Item cannot be empty");
    public static final StringLoadable<TagKey<Fluid>> FLUID_TAG = Loadables.tagKey(Registry.f_122899_);
    public static final StringLoadable<TagKey<MobEffect>> MOB_EFFECT_TAG = Loadables.tagKey(Registry.f_122900_);
    public static final StringLoadable<TagKey<Block>> BLOCK_TAG = Loadables.tagKey(Registry.f_122901_);
    public static final StringLoadable<TagKey<Enchantment>> ENCHANTMENT_TAG = Loadables.tagKey(Registry.f_122902_);
    public static final StringLoadable<TagKey<EntityType<?>>> ENTITY_TYPE_TAG = Loadables.tagKey(Registry.f_122903_);
    public static final StringLoadable<TagKey<Item>> ITEM_TAG = Loadables.tagKey(Registry.f_122904_);
    public static final StringLoadable<TagKey<Potion>> POTION_TAG = Loadables.tagKey(Registry.f_122905_);
    public static final StringLoadable<TagKey<BlockEntityType<?>>> BLOCK_ENTITY_TYPE_TAG = Loadables.tagKey(Registry.f_122907_);

    private Loadables() {
    }

    public static <T> StringLoadable<TagKey<T>> tagKey(ResourceKey<? extends Registry<T>> registry) {
        return RESOURCE_LOCATION.flatXmap(key -> TagKey.m_203882_((ResourceKey)registry, (ResourceLocation)key), TagKey::f_203868_);
    }

    public static <T> StringLoadable<T> notValue(StringLoadable<T> loadable, T notValue, String errorMsg) {
        BiFunction<Object, ErrorFactory, Object> mapper = (value, error) -> {
            if (value == notValue) {
                throw error.create(errorMsg);
            }
            return value;
        };
        return loadable.xmap(mapper, mapper);
    }
}

