/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.block.entity.IRetexturedBlockEntity;

public final class RetexturedHelper {
    public static final String TAG_TEXTURE = "texture";
    public static final ModelProperty<Block> BLOCK_PROPERTY = new ModelProperty(block -> block != Blocks.f_50016_);

    public static Block getBlock(String name) {
        Block block;
        ResourceLocation location;
        if (!name.isEmpty() && (location = ResourceLocation.m_135820_((String)name)) != null && (block = (Block)ForgeRegistries.BLOCKS.getValue(location)) != null) {
            return block;
        }
        return Blocks.f_50016_;
    }

    public static String getTextureName(@Nullable CompoundTag nbt) {
        if (nbt == null) {
            return "";
        }
        return nbt.m_128461_(TAG_TEXTURE);
    }

    public static String getTextureName(Block block) {
        if (block == Blocks.f_50016_) {
            return "";
        }
        return Objects.requireNonNull(block.getRegistryName()).toString();
    }

    public static void setTexture(@Nullable CompoundTag nbt, String texture) {
        if (nbt != null) {
            if (texture.isEmpty()) {
                nbt.m_128473_(TAG_TEXTURE);
            } else {
                nbt.m_128359_(TAG_TEXTURE, texture);
            }
        }
    }

    public static <T extends BlockEntity> void onTextureUpdated(T self) {
        Level level = self.m_58904_();
        if (level != null && level.f_46443_) {
            Block texture = ((IRetexturedBlockEntity)self).getTexture();
            texture = texture == Blocks.f_50016_ ? null : texture;
            IModelData data = self.getModelData();
            if (data.getData(BLOCK_PROPERTY) != texture) {
                data.setData(BLOCK_PROPERTY, (Object)texture);
                self.requestModelDataUpdate();
                BlockState state = self.m_58900_();
                level.m_7260_(self.m_58899_(), state, state, 0);
            }
        }
    }

    private RetexturedHelper() {
    }
}

