/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.loot;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import slimeknights.mantle.loot.MantleLoot;
import slimeknights.mantle.loot.builder.AbstractLootModifierBuilder;
import slimeknights.mantle.loot.condition.ILootModifierCondition;

public class AddEntryLootModifier
extends LootModifier {
    static final Gson GSON = Deserializers.m_78799_().registerTypeHierarchyAdapter(ILootModifierCondition.class, ILootModifierCondition.MODIFIER_CONDITIONS).create();
    private final ILootModifierCondition[] modifierConditions;
    private final LootPoolEntryContainer entry;
    private final LootItemFunction[] functions;
    private final BiFunction<ItemStack, LootContext, ItemStack> combinedFunctions;

    protected AddEntryLootModifier(LootItemCondition[] conditionsIn, ILootModifierCondition[] modifierConditions, LootPoolEntryContainer entry, LootItemFunction[] functions) {
        super(conditionsIn);
        this.modifierConditions = modifierConditions;
        this.entry = entry;
        this.functions = functions;
        this.combinedFunctions = LootItemFunctions.m_80770_((BiFunction[])functions);
    }

    public static Builder builder(LootPoolEntryContainer entry) {
        return new Builder(entry);
    }

    public static Builder builder(LootPoolEntryContainer.Builder<?> builder) {
        return AddEntryLootModifier.builder(builder.m_7512_());
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        for (ILootModifierCondition modifierCondition : this.modifierConditions) {
            if (modifierCondition.test(generatedLoot, context)) continue;
            return generatedLoot;
        }
        Consumer consumer = LootItemFunction.m_80724_(this.combinedFunctions, generatedLoot::add, (LootContext)context);
        this.entry.m_6562_(context, generator -> generator.m_6941_(consumer, context));
        return generatedLoot;
    }

    public static class Builder
    extends AbstractLootModifierBuilder<Builder> {
        private final List<ILootModifierCondition> modifierConditions = new ArrayList<ILootModifierCondition>();
        private final LootPoolEntryContainer entry;
        private final List<LootItemFunction> functions = new ArrayList<LootItemFunction>();

        public Builder addCondition(ILootModifierCondition condition) {
            this.modifierConditions.add(condition);
            return this;
        }

        public Builder addFunction(LootItemFunction function) {
            this.functions.add(function);
            return this;
        }

        @Override
        public void build(String name, GlobalLootModifierProvider provider) {
            provider.add(name, (GlobalLootModifierSerializer)MantleLoot.ADD_ENTRY, (IGlobalLootModifier)new AddEntryLootModifier(this.getConditions(), this.modifierConditions.toArray(new ILootModifierCondition[0]), this.entry, this.functions.toArray(new LootItemFunction[0])));
        }

        private Builder(LootPoolEntryContainer entry) {
            this.entry = entry;
        }
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AddEntryLootModifier> {
        public AddEntryLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] conditions) {
            LootPoolEntryContainer entry = (LootPoolEntryContainer)GSON.fromJson((JsonElement)GsonHelper.m_13930_((JsonObject)object, (String)"entry"), LootPoolEntryContainer.class);
            ILootModifierCondition[] modifierConditions = object.has("post_conditions") ? (ILootModifierCondition[])GSON.fromJson((JsonElement)GsonHelper.m_13933_((JsonObject)object, (String)"modifier_conditions"), ILootModifierCondition[].class) : new ILootModifierCondition[]{};
            LootItemFunction[] functions = object.has("functions") ? (LootItemFunction[])GSON.fromJson((JsonElement)GsonHelper.m_13933_((JsonObject)object, (String)"functions"), LootItemFunction[].class) : new LootItemFunction[]{};
            return new AddEntryLootModifier(conditions, modifierConditions, entry, functions);
        }

        public JsonObject write(AddEntryLootModifier instance) {
            JsonObject object = this.makeConditions(instance.conditions);
            if (instance.modifierConditions.length > 0) {
                object.add("modifier_conditions", GSON.toJsonTree((Object)instance.modifierConditions, ILootModifierCondition[].class));
            }
            object.add("entry", GSON.toJsonTree((Object)instance.entry, LootPoolEntryContainer.class));
            if (instance.functions.length > 0) {
                object.add("functions", GSON.toJsonTree((Object)instance.functions, LootItemFunction[].class));
            }
            return object;
        }
    }
}

