/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.util.JsonHelper;

public class NamedComponentRegistry<T> {
    private final BiMap<ResourceLocation, T> values = HashBiMap.create();
    private final String errorText;

    public NamedComponentRegistry(String errorText) {
        this.errorText = errorText + " ";
    }

    public <V extends T> V register(ResourceLocation name, V value) {
        if (this.values.putIfAbsent((Object)name, value) != null) {
            throw new IllegalArgumentException("Duplicate registration " + name);
        }
        return value;
    }

    @Nullable
    public T getValue(ResourceLocation name) {
        return (T)this.values.get((Object)name);
    }

    @Nullable
    public ResourceLocation getOptionalKey(T value) {
        return (ResourceLocation)this.values.inverse().get(value);
    }

    public ResourceLocation getKey(T value) {
        ResourceLocation key = this.getOptionalKey(value);
        if (key == null) {
            throw new IllegalStateException(this.errorText + value);
        }
        return key;
    }

    private T deserialize(ResourceLocation name) {
        T value = this.getValue(name);
        if (value == null) {
            throw new JsonSyntaxException(this.errorText + name);
        }
        return value;
    }

    public T convert(JsonElement element, String key) {
        return this.deserialize(JsonHelper.convertToResourceLocation(element, key));
    }

    public T deserialize(JsonObject parent, String key) {
        return this.deserialize(JsonHelper.getResourceLocation(parent, key));
    }

    public void toNetwork(T value, FriendlyByteBuf buffer) {
        buffer.m_130085_(this.getKey(value));
    }

    public void toNetworkOptional(@Nullable T value, FriendlyByteBuf buffer) {
        if (value != null) {
            buffer.m_130070_(this.getKey(value).toString());
        } else {
            buffer.m_130070_("");
        }
    }

    private T fromNetwork(ResourceLocation name) {
        T value = this.getValue(name);
        if (value == null) {
            throw new DecoderException(this.errorText + name);
        }
        return value;
    }

    public T fromNetwork(FriendlyByteBuf buffer) {
        return this.fromNetwork(buffer.m_130281_());
    }

    @Nullable
    public T fromNetworkOptional(FriendlyByteBuf buffer) {
        String key = buffer.m_130136_(Short.MAX_VALUE);
        if (key.isEmpty()) {
            return null;
        }
        return this.fromNetwork(new ResourceLocation(key));
    }
}

