/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.util;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import net.minecraftforge.common.model.TransformationHelper;
import slimeknights.mantle.client.model.util.DynamicBakedWrapper;

public class TRSRBakedModel
extends DynamicBakedWrapper<BakedModel> {
    private final Transformation transformation;
    private final TRSROverride override;
    private final int faceOffset;

    public TRSRBakedModel(BakedModel original, float x, float y, float z, float scale) {
        this(original, x, y, z, 0.0f, 0.0f, 0.0f, scale, scale, scale);
    }

    public TRSRBakedModel(BakedModel original, float x, float y, float z, float rotX, float rotY, float rotZ, float scale) {
        this(original, x, y, z, rotX, rotY, rotZ, scale, scale, scale);
    }

    public TRSRBakedModel(BakedModel original, float x, float y, float z, float rotX, float rotY, float rotZ, float scaleX, float scaleY, float scaleZ) {
        this(original, new Transformation(new Vector3f(x, y, z), null, new Vector3f(scaleX, scaleY, scaleZ), TransformationHelper.quatFromXYZ((float[])new float[]{rotX, rotY, rotZ}, (boolean)false)));
    }

    public TRSRBakedModel(BakedModel original, Transformation transform) {
        super(original);
        this.transformation = transform.blockCenterToCorner();
        this.override = new TRSROverride(this);
        this.faceOffset = 0;
    }

    public TRSRBakedModel(BakedModel original, Direction facing) {
        super(original);
        this.override = new TRSROverride(this);
        this.faceOffset = 4 + Direction.NORTH.m_122416_() - facing.m_122416_();
        double r = Math.PI * (double)(360 - facing.m_122424_().m_122416_() * 90) / 180.0;
        this.transformation = new Transformation(null, null, null, TransformationHelper.quatFromXYZ((float[])new float[]{0.0f, (float)r, 0.0f}, (boolean)false)).blockCenterToCorner();
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData data) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (!this.originalModel.m_7521_()) {
            try {
                if (side != null && side.m_122416_() > -1) {
                    side = Direction.m_122407_((int)((side.m_122416_() + this.faceOffset) % 4));
                }
                for (BakedQuad quad : this.originalModel.getQuads(state, side, rand, data)) {
                    Transformer transformer = new Transformer(this.transformation, quad.m_173410_());
                    quad.pipe((IVertexConsumer)transformer);
                    builder.add((Object)transformer.build());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return builder.build();
    }

    public ItemOverrides m_7343_() {
        return this.override;
    }

    private static class TRSROverride
    extends ItemOverrides {
        private final TRSRBakedModel model;

        TRSROverride(TRSRBakedModel model) {
            this.model = model;
        }

        @Nullable
        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            BakedModel baked = this.model.originalModel.m_7343_().m_173464_(originalModel, stack, world, entity, seed);
            if (baked == null) {
                return null;
            }
            return new TRSRBakedModel(baked, this.model.transformation);
        }
    }

    private static class Transformer
    extends VertexTransformer {
        protected Matrix4f transformation;
        protected Matrix3f normalTransformation;

        public Transformer(Transformation transformation, TextureAtlasSprite textureAtlasSprite) {
            super((IVertexConsumer)new BakedQuadBuilder(textureAtlasSprite));
            this.transformation = transformation.m_121104_();
            this.normalTransformation = new Matrix3f(this.transformation);
            this.normalTransformation.m_8187_();
            this.normalTransformation.m_8155_();
        }

        public void put(int element, float ... data) {
            VertexFormatElement.Usage usage = ((VertexFormatElement)this.parent.getVertexFormat().m_86023_().get(element)).m_86048_();
            if (usage == VertexFormatElement.Usage.POSITION && data.length >= 3) {
                Vector4f vec = new Vector4f(data[0], data[1], data[2], 1.0f);
                vec.m_123607_(this.transformation);
                data = new float[]{vec.m_123601_(), vec.m_123615_(), vec.m_123616_(), vec.m_123617_()};
            } else if (usage == VertexFormatElement.Usage.NORMAL && data.length >= 3) {
                Vector3f vec = new Vector3f(data);
                vec.m_122249_(this.normalTransformation);
                vec.m_122278_();
                data = new float[4];
                data[0] = vec.m_122239_();
                data[1] = vec.m_122260_();
                data[2] = vec.m_122269_();
            }
            super.put(element, data);
        }

        public BakedQuad build() {
            return ((BakedQuadBuilder)this.parent).build();
        }
    }
}

