/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import slimeknights.mantle.Mantle;

public class SimpleBlockModel
implements IModelGeometry<SimpleBlockModel> {
    public static final Loader LOADER = new Loader();
    static final ResourceLocation BAKE_LOCATION = Mantle.getResource("dynamic_model_baking");
    @Nullable
    private ResourceLocation parentLocation;
    private final List<BlockElement> parts;
    private final Map<String, Either<Material, String>> textures;
    private BlockModel parent;

    public SimpleBlockModel(@Nullable ResourceLocation parentLocation, Map<String, Either<Material, String>> textures, List<BlockElement> parts) {
        this.parts = parts;
        this.textures = textures;
        this.parentLocation = parentLocation;
    }

    public List<BlockElement> getElements() {
        return this.parts.isEmpty() && this.parent != null ? this.parent.m_111436_() : this.parts;
    }

    public void fetchParent(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter) {
        if (this.parent != null || this.parentLocation == null) {
            return;
        }
        LinkedHashSet chain = Sets.newLinkedHashSet();
        this.parent = SimpleBlockModel.getParent(modelGetter, chain, this.parentLocation, owner.getModelName());
        if (this.parent == null) {
            this.parent = SimpleBlockModel.getMissing(modelGetter);
            this.parentLocation = ModelBakery.f_119230_;
        }
        BlockModel link = this.parent;
        while (link.f_111419_ != null && link.f_111418_ == null) {
            chain.add(link);
            link.f_111418_ = SimpleBlockModel.getParent(modelGetter, chain, link.f_111419_, link.f_111416_);
            if (link.f_111418_ == null) {
                link.f_111418_ = SimpleBlockModel.getMissing(modelGetter);
                link.f_111419_ = ModelBakery.f_119230_;
            }
            link = link.f_111418_;
        }
    }

    @Nullable
    private static BlockModel getParent(Function<ResourceLocation, UnbakedModel> modelGetter, Set<UnbakedModel> chain, ResourceLocation location, String name) {
        UnbakedModel unbaked = modelGetter.apply(location);
        if (unbaked == null) {
            Mantle.logger.warn("No parent '{}' while loading model '{}'", (Object)location, (Object)name);
            return null;
        }
        if (chain.contains(unbaked)) {
            Mantle.logger.warn("Found 'parent' loop while loading model '{}' in chain: {} -> {}", (Object)name, (Object)chain.stream().map(Object::toString).collect(Collectors.joining(" -> ")), (Object)location);
            return null;
        }
        if (!(unbaked instanceof BlockModel)) {
            throw new IllegalStateException("BlockModel parent has to be a block model.");
        }
        return (BlockModel)unbaked;
    }

    @Nonnull
    private static BlockModel getMissing(Function<ResourceLocation, UnbakedModel> modelGetter) {
        UnbakedModel model = modelGetter.apply((ResourceLocation)ModelBakery.f_119230_);
        if (!(model instanceof BlockModel)) {
            throw new IllegalStateException("Failed to load missing model");
        }
        return (BlockModel)model;
    }

    public static Collection<Material> getTextures(IModelConfiguration owner, List<BlockElement> elements, Set<Pair<String, String>> missingTextureErrors) {
        HashSet textures = Sets.newHashSet((Object[])new Material[]{owner.resolveTexture("particle")});
        for (BlockElement part : elements) {
            for (BlockElementFace face : part.f_111310_.values()) {
                Material material = owner.resolveTexture(face.f_111356_);
                if (Objects.equals(material.m_119203_(), MissingTextureAtlasSprite.m_118071_())) {
                    missingTextureErrors.add((Pair<String, String>)Pair.of((Object)face.f_111356_, (Object)owner.getModelName()));
                }
                textures.add(material);
            }
        }
        return textures;
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        this.fetchParent(owner, modelGetter);
        return SimpleBlockModel.getTextures(owner, this.getElements(), missingTextureErrors);
    }

    public static void bakePart(SimpleBakedModel.Builder builder, IModelConfiguration owner, BlockElement part, ModelState transform, Function<Material, TextureAtlasSprite> spriteGetter, ResourceLocation location) {
        for (Direction direction : part.f_111310_.keySet()) {
            BlockElementFace face = (BlockElementFace)part.f_111310_.get(direction);
            String texture = face.f_111356_;
            if (texture.charAt(0) == '#') {
                texture = texture.substring(1);
            }
            TextureAtlasSprite sprite = spriteGetter.apply(owner.resolveTexture(texture));
            BakedQuad bakedQuad = BlockModel.m_111437_((BlockElement)part, (BlockElementFace)face, (TextureAtlasSprite)sprite, (Direction)direction, (ModelState)transform, (ResourceLocation)location);
            if (face.f_111354_ == null) {
                builder.m_119526_(bakedQuad);
                continue;
            }
            builder.m_119530_(Direction.m_122384_((Matrix4f)transform.m_6189_().m_121104_(), (Direction)face.f_111354_), bakedQuad);
        }
    }

    public static BakedModel bakeModel(IModelConfiguration owner, List<BlockElement> elements, ModelState transform, ItemOverrides overrides, Function<Material, TextureAtlasSprite> spriteGetter, ResourceLocation location) {
        TextureAtlasSprite particle = spriteGetter.apply(owner.resolveTexture("particle"));
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(owner, overrides).m_119528_(particle);
        for (BlockElement part : elements) {
            SimpleBlockModel.bakePart(builder, owner, part, transform, spriteGetter, location);
        }
        return builder.m_119533_();
    }

    public static BakedModel bakeDynamic(IModelConfiguration owner, List<BlockElement> elements, ModelState transform) {
        return SimpleBlockModel.bakeModel(owner, elements, transform, ItemOverrides.f_111734_, ForgeModelBakery.defaultTextureGetter(), BAKE_LOCATION);
    }

    public BakedModel bakeModel(IModelConfiguration owner, ModelState transform, ItemOverrides overrides, Function<Material, TextureAtlasSprite> spriteGetter, ResourceLocation location) {
        return SimpleBlockModel.bakeModel(owner, this.getElements(), transform, overrides, spriteGetter, location);
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ItemOverrides overrides, ResourceLocation location) {
        return this.bakeModel(owner, transform, overrides, spriteGetter, location);
    }

    public BakedModel bakeDynamic(IModelConfiguration owner, ModelState transform) {
        return SimpleBlockModel.bakeDynamic(owner, this.getElements(), transform);
    }

    public static SimpleBlockModel deserialize(JsonDeserializationContext context, JsonObject json) {
        ImmutableMap textureMap;
        ResourceLocation parent;
        String parentName = GsonHelper.m_13851_((JsonObject)json, (String)"parent", (String)"");
        ResourceLocation resourceLocation = parent = parentName.isEmpty() ? null : new ResourceLocation(parentName);
        if (json.has("textures")) {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            ResourceLocation atlas = InventoryMenu.f_39692_;
            JsonObject textures = GsonHelper.m_13930_((JsonObject)json, (String)"textures");
            for (Map.Entry entry : textures.entrySet()) {
                builder.put((Object)((String)entry.getKey()), (Object)BlockModel.Deserializer.m_111503_((ResourceLocation)atlas, (String)((JsonElement)entry.getValue()).getAsString()));
            }
            textureMap = builder.build();
        } else {
            textureMap = Collections.emptyMap();
        }
        List<Object> parts = json.has("elements") ? SimpleBlockModel.getModelElements(context, (JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"elements"), "elements") : Collections.emptyList();
        return new SimpleBlockModel(parent, (Map<String, Either<Material, String>>)textureMap, (List<BlockElement>)parts);
    }

    public static List<BlockElement> getModelElements(JsonDeserializationContext context, JsonElement array, String name) {
        if (array.isJsonObject()) {
            return ImmutableList.of((Object)((BlockElement)context.deserialize((JsonElement)array.getAsJsonObject(), BlockElement.class)));
        }
        if (array.isJsonArray()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JsonElement json : array.getAsJsonArray()) {
                builder.add((Object)((BlockElement)context.deserialize(json, BlockElement.class)));
            }
            return builder.build();
        }
        throw new JsonSyntaxException("Missing " + name + ", expected to find a JsonArray or JsonObject");
    }

    @Nullable
    public ResourceLocation getParentLocation() {
        return this.parentLocation;
    }

    public Map<String, Either<Material, String>> getTextures() {
        return this.textures;
    }

    public BlockModel getParent() {
        return this.parent;
    }

    private static class Loader
    implements IModelLoader<SimpleBlockModel> {
        private Loader() {
        }

        public void m_6213_(ResourceManager resourceManager) {
        }

        public SimpleBlockModel read(JsonDeserializationContext context, JsonObject json) {
            return SimpleBlockModel.deserialize(context, json);
        }
    }
}

