/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility.block.entity;

import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.utility.InspirationsUtility;
import knightminer.inspirations.utility.block.PipeBlock;
import knightminer.inspirations.utility.block.menu.PipeContainerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.block.entity.InventoryBlockEntity;
import slimeknights.mantle.util.WeakConsumerWrapper;

public class PipeBlockEntity
extends InventoryBlockEntity {
    public static final BlockEntityTicker<PipeBlockEntity> SERVER_TICKER = (level, pos, state, te) -> te.tick();
    private static final Component TITLE = Component.m_237115_((String)"gui.inspirations.pipe");
    private short cooldown = 0;
    @Nullable
    private LazyOptional<IItemHandler> facingHandler = null;
    @Nullable
    private WeakReference<HopperBlockEntity> hopper;
    private final NonNullConsumer<IItemHandler> transferItem = this::transferItem;
    private final NonNullConsumer<LazyOptional<IItemHandler>> facingInvalidator = new WeakConsumerWrapper((Object)this, (te, handler) -> {
        if (te.facingHandler == handler) {
            te.clearCachedInventories();
        }
    });
    private static final String TAG_COOLDOWN = "cooldown";

    public PipeBlockEntity(BlockPos pos, BlockState state) {
        super(InspirationsUtility.tilePipe, pos, state, TITLE, false, 1);
    }

    private void tick() {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)PipeBlock.FACING);
        if (!((Boolean)Config.pipeUpwards.get()).booleanValue() && facing == Direction.UP) {
            return;
        }
        this.cooldown = (short)(this.cooldown - 1);
        if (this.cooldown > 0) {
            return;
        }
        this.cooldown = 0;
        if (this.m_7983_()) {
            return;
        }
        this.getHandler(facing).ifPresent(this.transferItem);
    }

    private LazyOptional<IItemHandler> getHandler(Direction facing) {
        LazyOptional handler;
        if (this.facingHandler != null) {
            return this.facingHandler;
        }
        assert (this.f_58857_ != null);
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(facing));
        if (te != null && (handler = te.getCapability(ForgeCapabilities.ITEM_HANDLER, facing.m_122424_())).isPresent()) {
            handler.addListener(this.facingInvalidator);
            if (te instanceof HopperBlockEntity) {
                this.hopper = new WeakReference<HopperBlockEntity>((HopperBlockEntity)te);
            }
            this.facingHandler = handler;
            return this.facingHandler;
        }
        this.facingHandler = LazyOptional.empty();
        return this.facingHandler;
    }

    private void transferItem(IItemHandler neighbor) {
        ItemStack stack = this.m_8020_(0);
        if (stack.m_41619_()) {
            return;
        }
        ItemStack copy = stack.m_41777_();
        copy.m_41764_(1);
        if (ItemHandlerHelper.insertItemStacked((IItemHandler)neighbor, (ItemStack)copy, (boolean)false).m_41619_()) {
            HopperBlockEntity hop;
            if (this.hopper != null && (hop = (HopperBlockEntity)this.hopper.get()) != null) {
                hop.m_59395_(8);
            }
            stack.m_41774_(1);
            if (stack.m_41619_()) {
                this.m_6836_(0, ItemStack.f_41583_);
            }
            this.cooldown = (short)8;
            this.m_6596_();
        }
    }

    public void clearCachedInventories() {
        this.facingHandler = null;
        this.hopper = null;
    }

    public void m_155250_(BlockState pBlockState) {
        super.m_155250_(pBlockState);
        this.clearCachedInventories();
    }

    public void m_6836_(int slot, ItemStack itemstack) {
        super.m_6836_(slot, itemstack);
        this.cooldown = (short)7;
    }

    public AbstractContainerMenu m_7208_(int winId, Inventory inv, Player entity) {
        return new PipeContainerMenu(winId, inv, this);
    }

    public void m_142466_(CompoundTag tags) {
        super.m_142466_(tags);
        this.cooldown = tags.m_128448_(TAG_COOLDOWN);
    }

    public void m_183515_(CompoundTag tags) {
        super.m_183515_(tags);
        tags.m_128376_(TAG_COOLDOWN, this.cooldown);
    }
}

