/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public class BricksButtonBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final BooleanProperty POWERED = ButtonBlock.f_51045_;
    private final Map<Direction, AABB> buttonBounds;
    public static final ImmutableMap<Direction, AABB> BRICK_BUTTON;
    public static final ImmutableMap<Direction, AABB> NETHER_BUTTON;

    public BricksButtonBlock(BlockBehaviour.Properties props, Map<Direction, AABB> buttonBounds) {
        super(props);
        this.buttonBounds = buttonBounds;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED});
        super.m_7926_(builder);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity player, ItemStack stack) {
        if (player != null) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)FACING, (Comparable)player.m_6374_().m_122424_()));
        }
        super.m_6402_(world, pos, state, player, stack);
    }

    @Deprecated
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Deprecated
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)FACING)));
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult trace) {
        if (!this.getButtonBox(state).m_82390_(trace.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()))) {
            return InteractionResult.PASS;
        }
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            return InteractionResult.SUCCESS;
        }
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        world.m_5594_(player, pos, SoundEvents.f_12444_, SoundSource.BLOCKS, 0.3f, 0.6f);
        world.m_46672_(pos, (Block)this);
        world.m_186460_(pos, (Block)this, 20);
        return InteractionResult.SUCCESS;
    }

    @Deprecated
    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (world.f_46443_) {
            return;
        }
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
            world.m_46672_(pos, (Block)this);
            world.m_5594_(null, pos, SoundEvents.f_12443_, SoundSource.BLOCKS, 0.3f, 0.5f);
        }
    }

    private AABB getButtonBox(BlockState state) {
        return this.buttonBounds.get(state.m_61143_((Property)FACING));
    }

    @Deprecated
    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_() && ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            world.m_46672_(pos, (Block)this);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    @Deprecated
    public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return (Boolean)state.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    @Deprecated
    public int m_6376_(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return 0;
    }

    @Deprecated
    public boolean m_7899_(BlockState state) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return false;
    }

    static {
        ImmutableMap.Builder bounds = ImmutableMap.builder();
        bounds.put((Object)Direction.NORTH, (Object)new AABB(0.3125, 0.3125, 0.0, 0.75, 0.5, 0.0625));
        bounds.put((Object)Direction.SOUTH, (Object)new AABB(0.25, 0.3125, 0.9375, 0.6875, 0.5, 1.0125));
        bounds.put((Object)Direction.WEST, (Object)new AABB(0.0, 0.3125, 0.25, 0.0625, 0.5, 0.6875));
        bounds.put((Object)Direction.EAST, (Object)new AABB(0.9375, 0.3125, 0.3125, 1.0125, 0.5, 0.75));
        BRICK_BUTTON = bounds.build();
        bounds = ImmutableMap.builder();
        bounds.put((Object)Direction.NORTH, (Object)new AABB(0.5, 0.5, 0.0, 0.9375, 0.6875, 0.0625));
        bounds.put((Object)Direction.SOUTH, (Object)new AABB(0.0625, 0.5, 0.9375, 0.5, 0.6875, 1.0125));
        bounds.put((Object)Direction.WEST, (Object)new AABB(0.0, 0.5, 0.0625, 0.0625, 0.6875, 0.5));
        bounds.put((Object)Direction.EAST, (Object)new AABB(0.9375, 0.5, 0.5, 1.0125, 0.6875, 0.9375));
        NETHER_BUTTON = bounds.build();
    }
}

