/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks;

import java.util.List;
import knightminer.inspirations.common.AbstractClientEvents;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.client.model.TrimModel;
import knightminer.inspirations.tweaks.InspirationsTweaks;
import knightminer.inspirations.tweaks.client.PortalColorHandler;
import knightminer.inspirations.tweaks.client.TintedLecternRenderer;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="inspirations", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class TweaksClientEvents
extends AbstractClientEvents {
    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(TweaksClientEvents::fixShieldTooltip);
    }

    @SubscribeEvent
    static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        if (Config.tintLecternBook.getAsBoolean()) {
            event.registerBlockEntityRenderer(BlockEntityType.f_58908_, TintedLecternRenderer::new);
        }
    }

    @SubscribeEvent
    static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("trim", TrimModel.LOADER);
    }

    @SubscribeEvent
    static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        BlockColors colors = event.getBlockColors();
        TweaksClientEvents.registerBlockColors(colors, (state, world, pos, index) -> {
            if (world == null || pos == null) {
                return -1;
            }
            return BiomeColors.m_108793_((BlockAndTintGetter)world, (BlockPos)pos);
        }, new Block[]{InspirationsTweaks.sugarCane});
        TweaksClientEvents.registerBlockColors(colors, PortalColorHandler.INSTANCE, Blocks.f_50142_);
    }

    @SubscribeEvent
    static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        TweaksClientEvents.registerItemColors(itemColors, (stack, tintIndex) -> {
            if (tintIndex == 0 && ((Boolean)Config.coloredEnchantedRibbons.get()).booleanValue()) {
                Enchantment.Rarity rarity = Enchantment.Rarity.COMMON;
                for (Tag tag : EnchantedBookItem.m_41163_((ItemStack)stack)) {
                    Enchantment.Rarity newRarity;
                    ResourceLocation id;
                    Enchantment enchantment;
                    if (tag.m_7060_() != 10 || (enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(id = new ResourceLocation(((CompoundTag)tag).m_128461_("id")))) == null || (newRarity = enchantment.m_44699_()).m_44716_() >= rarity.m_44716_()) continue;
                    rarity = newRarity;
                }
                return switch (rarity) {
                    default -> throw new IncompatibleClassChangeError();
                    case Enchantment.Rarity.COMMON -> 16720209;
                    case Enchantment.Rarity.UNCOMMON -> 14845997;
                    case Enchantment.Rarity.RARE -> 65313;
                    case Enchantment.Rarity.VERY_RARE -> 0x9F7FFF;
                };
            }
            return -1;
        }, new ItemLike[]{Items.f_42690_});
        TweaksClientEvents.registerItemColors(itemColors, (stack, tintIndex) -> {
            if (!((Boolean)Config.coloredFireworkItems.get()).booleanValue()) {
                return -1;
            }
            CompoundTag nbt = stack.m_41737_("Fireworks");
            if (tintIndex == 2) {
                if (nbt != null && nbt.m_128425_("Flight", 99)) {
                    byte flight = nbt.m_128445_("Flight");
                    switch (flight) {
                        case 1: {
                            return 0x808080;
                        }
                        case 2: {
                            return 0x606060;
                        }
                        case 3: {
                            return 0x303030;
                        }
                    }
                    if (flight > 3) {
                        return 0;
                    }
                }
                return 0xA0A0A0;
            }
            if (tintIndex == 0 || tintIndex == 1) {
                int missing;
                int n = missing = tintIndex == 1 ? 13410704 : 0xC0C0C0;
                if (nbt == null) {
                    return missing;
                }
                ListTag stars = nbt.m_128437_("Explosions", 10);
                if (tintIndex >= stars.size()) {
                    return missing;
                }
                CompoundTag star = stars.m_128728_(tintIndex);
                int[] colors = star.m_128465_("Colors");
                if (colors.length > 0) {
                    return colors[0];
                }
                return missing;
            }
            return -1;
        }, new ItemLike[]{Items.f_42688_});
    }

    private static void fixShieldTooltip(ItemTooltipEvent event) {
        if (!Config.fixShieldTooltip.getAsBoolean()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_() != Items.f_42740_) {
            return;
        }
        CompoundTag tags = stack.m_41737_("BlockEntityTag");
        if (tags != null && tags.m_128441_("Patterns") && stack.m_41793_()) {
            List text = event.getToolTip();
            for (int i = text.size() - 1; i >= 0; --i) {
                TranslatableContents translatable;
                Component component = (Component)text.get(i);
                ComponentContents componentContents = component.m_214077_();
                if (!(componentContents instanceof TranslatableContents) || !(translatable = (TranslatableContents)componentContents).m_237508_().contains("banner")) continue;
                text.add(i + 1, Component.m_237119_());
                break;
            }
        }
    }
}

