/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.fml.ModList;

public class ModItemList
extends CompoundIngredient {
    public static final Factory SERIALIZER = new Factory();

    protected ModItemList(List<Ingredient> children) {
        super(children);
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return new Factory();
    }

    public static class Factory
    implements IIngredientSerializer<ModItemList> {
        public ModItemList parse(JsonObject json) {
            LinkedList<Ingredient> ingredientList = new LinkedList<Ingredient>();
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            for (JsonElement ingredient : ingredients) {
                JsonObject object = ingredient.getAsJsonObject();
                if (GsonHelper.m_13900_((JsonObject)object, (String)"modid")) {
                    String mod = GsonHelper.m_13906_((JsonObject)object, (String)"modid");
                    if (!ModList.get().isLoaded(mod)) continue;
                }
                if (GsonHelper.m_13900_((JsonObject)object, (String)"ingredient")) {
                    ingredientList.add(CraftingHelper.getIngredient((JsonElement)object.get("ingredient"), (boolean)false));
                    continue;
                }
                ingredientList.add(CraftingHelper.getIngredient((JsonElement)object, (boolean)false));
            }
            return new ModItemList(ingredientList);
        }

        public void write(FriendlyByteBuf buffer, ModItemList ingredient) {
            buffer.m_130130_(ingredient.getChildren().size());
            ingredient.getChildren().forEach(child -> child.m_43923_(buffer));
        }

        public ModItemList parse(FriendlyByteBuf buffer) {
            return new ModItemList(Stream.generate(() -> Ingredient.m_43940_((FriendlyByteBuf)buffer)).limit(buffer.m_130242_()).collect(Collectors.toList()));
        }
    }
}

