/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.cauldrons.item;

import java.util.List;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.item.ConstantFluidContainerWrapper;

public class MilkBottleItem
extends Item {
    private static final Random RANDOM = new Random();
    private static final int DRINK_DURATION = 32;

    public MilkBottleItem(Item.Properties props) {
        super(props);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity living) {
        if (living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            CriteriaTriggers.f_10592_.m_23682_(player, stack);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
        if (!level.f_46443_) {
            ItemStack milkBucket = new ItemStack((ItemLike)Items.f_42455_);
            List<MobEffect> effects = living.m_21220_().stream().filter(effect -> effect.isCurativeItem(milkBucket)).map(MobEffectInstance::m_19544_).toList();
            if (!effects.isEmpty()) {
                living.m_21195_(effects.get(RANDOM.nextInt(effects.size())));
            }
        }
        ItemStack container = stack.getCraftingRemainingItem().m_41777_();
        if (living instanceof Player) {
            Player player = (Player)living;
            return ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)container);
        }
        stack.m_41774_(1);
        if (stack.m_41619_()) {
            return container;
        }
        living.m_19983_(container);
        return stack;
    }

    public int m_8105_(ItemStack pStack) {
        return 32;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.DRINK;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        return ItemUtils.m_150959_((Level)pLevel, (Player)pPlayer, (InteractionHand)pHand);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (ForgeMod.MILK.isPresent()) {
            return new ConstantFluidContainerWrapper(new FluidStack((Fluid)ForgeMod.MILK.get(), 250), stack);
        }
        return null;
    }
}

