/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks.block;

import javax.annotation.Nullable;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.tweaks.InspirationsTweaks;
import knightminer.inspirations.tweaks.block.FittedCarpetBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.HitResult;

public class FlatCarpetBlock
extends WoolCarpetBlock {
    protected static final BooleanProperty NORTHWEST = BooleanProperty.m_61465_((String)"northwest");
    protected static final BooleanProperty NORTHEAST = BooleanProperty.m_61465_((String)"northeast");
    protected static final BooleanProperty SOUTHWEST = BooleanProperty.m_61465_((String)"southwest");
    protected static final BooleanProperty SOUTHEAST = BooleanProperty.m_61465_((String)"southeast");
    private static final int SHAPE_FLAT = 0;

    public FlatCarpetBlock(DyeColor color, BlockBehaviour.Properties props) {
        super(color, props);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        int shape = FlatCarpetBlock.getStairShape(world.m_8055_(pos.m_7495_()));
        if (shape != 0) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((FittedCarpetBlock)((Object)InspirationsTweaks.fitCarpets.get((Enum)this.m_58309_()))).m_49966_().m_61124_((Property)NORTHWEST, (Comparable)Boolean.valueOf((shape & 8) > 0))).m_61124_((Property)NORTHEAST, (Comparable)Boolean.valueOf((shape & 4) > 0))).m_61124_((Property)SOUTHWEST, (Comparable)Boolean.valueOf((shape & 2) > 0))).m_61124_((Property)SOUTHEAST, (Comparable)Boolean.valueOf((shape & 1) > 0));
        }
        return ((Block)InspirationsTweaks.flatCarpets.get((Enum)this.m_58309_())).m_49966_();
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        world.m_7731_(pos, this.m_7417_(state, Direction.UP, state, (LevelAccessor)world, pos, pos), 2);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)InspirationsTweaks.flatCarpets.get((Enum)this.m_58309_()));
    }

    private static int getStairShape(BlockState stairs) {
        if (!Config.enableFittedCarpets.getAsBoolean()) {
            return 0;
        }
        if (!(stairs.m_60734_() instanceof StairBlock) || stairs.m_61143_((Property)StairBlock.f_56842_) != Half.BOTTOM) {
            return 0;
        }
        StairsShape shape = (StairsShape)stairs.m_61143_((Property)StairBlock.f_56843_);
        return switch ((Direction)stairs.m_61143_((Property)StairBlock.f_56841_)) {
            case Direction.NORTH -> {
                switch (shape) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case STRAIGHT: {
                        yield 3;
                    }
                    case INNER_LEFT: {
                        yield 1;
                    }
                    case INNER_RIGHT: {
                        yield 2;
                    }
                    case OUTER_LEFT: {
                        yield 7;
                    }
                    case OUTER_RIGHT: 
                }
                yield 11;
            }
            case Direction.SOUTH -> {
                switch (shape) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case STRAIGHT: {
                        yield 12;
                    }
                    case INNER_LEFT: {
                        yield 8;
                    }
                    case INNER_RIGHT: {
                        yield 4;
                    }
                    case OUTER_LEFT: {
                        yield 14;
                    }
                    case OUTER_RIGHT: 
                }
                yield 13;
            }
            case Direction.WEST -> {
                switch (shape) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case STRAIGHT: {
                        yield 5;
                    }
                    case INNER_LEFT: {
                        yield 4;
                    }
                    case INNER_RIGHT: {
                        yield 1;
                    }
                    case OUTER_LEFT: {
                        yield 13;
                    }
                    case OUTER_RIGHT: 
                }
                yield 7;
            }
            case Direction.EAST -> {
                switch (shape) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case STRAIGHT: {
                        yield 10;
                    }
                    case INNER_LEFT: {
                        yield 2;
                    }
                    case INNER_RIGHT: {
                        yield 8;
                    }
                    case OUTER_LEFT: {
                        yield 11;
                    }
                    case OUTER_RIGHT: 
                }
                yield 14;
            }
            default -> 0;
        };
    }
}

