/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import slimeknights.mantle.data.loadable.Loadables;

public class ConfigurableResourcePack
extends AbstractPackResources
implements RepositorySource {
    private final Class<?> resourceLoader;
    private final String packId;
    private final Component displayName;
    private final Component description;
    private final String pathPrefix;
    private final Set<String> namespaces;
    private final Map<String, Replacement> replacements = new HashMap<String, Replacement>();

    public ConfigurableResourcePack(Class<?> resourceLoader, ResourceLocation packId, Component displayName, Component description, Set<String> namespaces) {
        this(resourceLoader, packId.toString(), String.format(Locale.ROOT, "/%s/%s/%s/", PackType.CLIENT_RESOURCES.m_10305_(), packId.m_135827_(), packId.m_135815_()), displayName, description, namespaces);
    }

    private ConfigurableResourcePack(Class<?> resourceLoader, String packId, String pathPrefix, Component displayName, Component description, Set<String> namespaces) {
        super(packId, true);
        this.resourceLoader = resourceLoader;
        this.packId = packId;
        this.displayName = displayName;
        this.description = description;
        this.pathPrefix = pathPrefix;
        this.namespaces = namespaces;
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... elements) {
        return this.getResource(String.join((CharSequence)"/", elements));
    }

    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType packType, ResourceLocation location) {
        return this.getResource(String.format(Locale.ROOT, "%s/%s/%s", packType.m_10305_(), location.m_135827_(), location.m_135815_()));
    }

    public Set<String> m_5698_(PackType type) {
        return type == PackType.CLIENT_RESOURCES ? this.namespaces : Collections.emptySet();
    }

    private InputStream getPackResource(String name) throws IOException {
        InputStream stream = this.resourceLoader.getResourceAsStream(this.pathPrefix + name);
        if (stream != null) {
            return stream;
        }
        throw new FileNotFoundException("Failed to open resource at " + this.pathPrefix + name);
    }

    private IoSupplier<InputStream> getIoSupplier(String name) {
        return () -> this.getPackResource(name);
    }

    @Nullable
    private IoSupplier<InputStream> getResource(String name) {
        if (name.equals("pack.mcmeta") || name.equals("pack.png")) {
            return this.getIoSupplier(name);
        }
        Replacement replacement = this.replacements.get(name);
        if (replacement != null && replacement.isEnabled()) {
            return this.getIoSupplier(replacement.name());
        }
        if (replacement != null && !replacement.isEnabled()) {
            Inspirations.log.warn("Replacement {} for {} not enabled", (Object)replacement.name, (Object)name);
        }
        return null;
    }

    public void m_8031_(PackType packType, String namespace, String folder, PackResources.ResourceOutput output) {
        String root = packType.m_10305_() + "/" + namespace + "/";
        String prefix = root + folder + "/";
        for (Map.Entry<String, Replacement> entry : this.replacements.entrySet()) {
            ResourceLocation location;
            String path;
            Replacement replacement = entry.getValue();
            if (!replacement.isEnabled() || !(path = entry.getKey()).startsWith(prefix) || (location = ResourceLocation.m_214293_((String)namespace, (String)path.substring(root.length()))) == null) continue;
            output.accept((Object)location, this.getIoSupplier(replacement.name));
        }
    }

    public void close() {
    }

    public void m_7686_(Consumer<Pack> consumer) {
        consumer.accept(Pack.m_245512_((String)this.packId, (Component)this.displayName, (boolean)true, id -> this, (Pack.Info)new Pack.Info(this.description, SharedConstants.m_183709_().m_264084_(PackType.SERVER_DATA), SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES), FeatureFlags.f_244280_.m_247355_(), false), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10528_));
    }

    public void addReplacement(BooleanSupplier condition, String originalPath, String resource) {
        Replacement original = this.replacements.putIfAbsent(originalPath, new Replacement(condition, resource));
        if (original != null) {
            Inspirations.log.warn("Duplicate replacement '{}' for configurable pack {}.", (Object)originalPath, (Object)this.packId);
        }
    }

    private static String makePath(ResourceLocation id, String folder, String extension) {
        return String.format("%s/%s/%s/%s.%s", PackType.CLIENT_RESOURCES.m_10305_(), id.m_135827_(), folder, id.m_135815_(), extension);
    }

    public void addBlockstateReplacement(BooleanSupplier condition, Block block, String resource) {
        this.addReplacement(condition, ConfigurableResourcePack.makePath(Loadables.BLOCK.getKey((Object)block), "blockstates", "json"), "blockstates/" + resource + ".json");
    }

    public void addBlockstateReplacement(ForgeConfigSpec.BooleanValue condition, Block block, String resource) {
        this.addBlockstateReplacement(() -> ((ForgeConfigSpec.BooleanValue)condition).get(), block, resource);
    }

    public void addItemModelReplacement(BooleanSupplier condition, ItemLike item, String resource) {
        this.addReplacement(condition, ConfigurableResourcePack.makePath(Loadables.ITEM.getKey((Object)item.m_5456_()), "models/item", "json"), "item_models/" + resource + ".json");
    }

    public void addItemModelReplacement(ForgeConfigSpec.BooleanValue condition, ItemLike item, String resource) {
        this.addItemModelReplacement(() -> ((ForgeConfigSpec.BooleanValue)condition).get(), item, resource);
    }

    private record Replacement(BooleanSupplier condition, String name) {
        public boolean isEnabled() {
            return this.condition.getAsBoolean();
        }
    }
}

