/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common.datagen;

import java.util.concurrent.CompletableFuture;
import knightminer.inspirations.building.InspirationsBuilding;
import knightminer.inspirations.cauldrons.InspirationsCaudrons;
import knightminer.inspirations.library.InspirationsTags;
import knightminer.inspirations.tweaks.InspirationsTweaks;
import knightminer.inspirations.utility.InspirationsUtility;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.mantle.registration.object.EnumObject;

public class InspirationsBlockTagsProvider
extends BlockTagsProvider {
    public InspirationsBlockTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existing) {
        super(output, lookupProvider, "inspirations", existing);
    }

    public String m_6055_() {
        return "Inspirations Block Tags";
    }

    protected void m_6577_(HolderLookup.Provider provider) {
        this.registerInspTags();
        this.registerVanillaTags();
        this.registerHarvestTags();
    }

    private void registerInspTags() {
        this.m_206424_(InspirationsTags.Blocks.MULCH).m_255179_((Object[])InspirationsBlockTagsProvider.toArray(InspirationsBuilding.mulch));
        this.m_206424_(BlockTags.f_13037_).m_255179_((Object[])InspirationsBlockTagsProvider.toArray(InspirationsBuilding.flower));
        this.m_206424_(BlockTags.f_13045_).m_255179_((Object[])InspirationsBlockTagsProvider.toArray(InspirationsBuilding.flowerPot));
        this.m_206424_(InspirationsTags.Blocks.ENLIGHTENED_BUSHES).m_255179_((Object[])InspirationsBlockTagsProvider.toArray(InspirationsBuilding.enlightenedBush));
        this.m_206424_(InspirationsTags.Blocks.SHELVES).m_255179_((Object[])InspirationsBlockTagsProvider.toArray(InspirationsBuilding.shelf));
        this.m_206424_(BlockTags.f_13082_).m_255179_((Object[])new Block[]{InspirationsBuilding.rope, InspirationsBuilding.vine});
        this.m_206424_(BlockTags.f_13103_).m_255245_((Object)InspirationsBuilding.glassDoor);
        this.m_206424_(BlockTags.f_13036_).m_255245_((Object)InspirationsBuilding.glassTrapdoor);
        this.m_206424_(BlockTags.f_13095_).m_255245_((Object)InspirationsBuilding.glassDoor);
        this.m_206424_(InspirationsTags.Blocks.CARPETED_TRAPDOORS).m_255179_((Object[])InspirationsBlockTagsProvider.toArray(InspirationsUtility.carpetedTrapdoors));
        this.m_206424_(InspirationsTags.Blocks.CARPETED_PRESSURE_PLATES).m_255179_((Object[])InspirationsBlockTagsProvider.toArray(InspirationsUtility.carpetedPressurePlates));
        this.m_206424_(InspirationsTags.Blocks.CAULDRON_FIRE).m_255179_((Object[])new Block[]{Blocks.f_50083_, Blocks.f_50084_}).m_206428_(BlockTags.f_13087_);
        this.m_206424_(InspirationsTags.Blocks.CAULDRON_ICE).m_255179_((Object[])new Block[]{Blocks.f_50354_, Blocks.f_50568_});
    }

    private void registerVanillaTags() {
        this.m_206424_(BlockTags.f_13035_).m_206428_(InspirationsTags.Blocks.ENLIGHTENED_BUSHES);
        this.m_206424_(BlockTags.f_13065_).m_206428_(InspirationsTags.Blocks.MULCH);
        this.m_206424_(BlockTags.f_13102_).m_206428_(InspirationsTags.Blocks.CARPETED_TRAPDOORS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender carpets = this.m_206424_(BlockTags.f_215838_);
        InspirationsTweaks.fitCarpets.forEach(block -> carpets.m_255245_((Object)block));
        this.m_206424_(BlockTags.f_13042_).m_255179_((Object[])new Block[]{InspirationsUtility.soulLeverWall, InspirationsUtility.soulLeverFloor});
        this.m_206424_(BlockTags.f_13081_).m_255179_((Object[])new Block[]{InspirationsUtility.torchLeverFloor, InspirationsUtility.torchLeverWall, InspirationsUtility.soulLeverFloor, InspirationsUtility.soulLeverWall});
        this.m_206424_(BlockTags.f_144269_).m_255179_((Object[])new Block[]{InspirationsCaudrons.beetrootSoupCauldron, InspirationsCaudrons.mushroomStewCauldron, InspirationsCaudrons.potatoSoupCauldron, InspirationsCaudrons.rabbitStewCauldron, InspirationsCaudrons.honeyCauldron, InspirationsCaudrons.milkCauldron, InspirationsCaudrons.dyeCauldron, InspirationsCaudrons.potionCauldron, InspirationsCaudrons.suspiciousStewCauldron});
    }

    private void registerHarvestTags() {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender hoeBlocks = this.m_206424_(BlockTags.f_144281_);
        hoeBlocks.m_255179_((Object[])new Block[]{InspirationsBuilding.rope, InspirationsBuilding.vine});
        InspirationsBuilding.enlightenedBush.forEach(block -> hoeBlocks.m_255245_((Object)block));
        IntrinsicHolderTagsProvider.IntrinsicTagAppender axeBlocks = this.m_206424_(BlockTags.f_144280_);
        axeBlocks.m_255245_((Object)InspirationsTweaks.sugarCane);
        InspirationsBuilding.shelf.forEach(block -> axeBlocks.m_255245_((Object)block));
        InspirationsBuilding.flower.forEach(block -> axeBlocks.m_255245_((Object)block));
        IntrinsicHolderTagsProvider.IntrinsicTagAppender shovelBlocks = this.m_206424_(BlockTags.f_144283_);
        InspirationsBuilding.mulch.forEach(block -> shovelBlocks.m_255245_((Object)block));
        IntrinsicHolderTagsProvider.IntrinsicTagAppender pickBlocks = this.m_206424_(BlockTags.f_144282_);
        pickBlocks.m_255179_((Object[])new Block[]{InspirationsTweaks.wetHopper, InspirationsUtility.collector, InspirationsUtility.pipe});
        InspirationsBuilding.path.forEach(block -> pickBlocks.m_255245_((Object)block));
        InspirationsUtility.carpetedPressurePlates.forEach(block -> pickBlocks.m_255245_((Object)block));
    }

    private static Block[] toArray(EnumObject<?, ? extends Block> object) {
        return object.values().toArray(new Block[0]);
    }
}

