/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks.block;

import java.util.function.Supplier;
import knightminer.inspirations.common.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public abstract class BlockCropBlock
extends CropBlock
implements IPlantable {
    public static final IntegerProperty LARGE_AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)14);
    protected Supplier<Block> block;
    protected PlantType type;

    public BlockCropBlock(Supplier<Block> block, PlantType type, BlockBehaviour.Properties props) {
        super(props);
        this.block = block;
        this.type = type;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{this.m_7959_()});
    }

    public IntegerProperty m_7959_() {
        return LARGE_AGE;
    }

    public int m_7419_() {
        return 15;
    }

    public BlockState m_52289_(int age) {
        if (age == this.m_7419_()) {
            return this.block.get().m_49966_();
        }
        return super.m_52289_(age);
    }

    public boolean m_52307_(BlockState state) {
        return false;
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int max;
        if (!world.isAreaLoaded(pos, 1)) {
            return;
        }
        int age = this.m_52305_(state);
        if (age < (max = this.m_7419_()) && ForgeHooks.onCropsGrowPre((Level)world, (BlockPos)pos, (BlockState)state, (boolean)true)) {
            BlockState newState = this.m_52289_(++age);
            if (age == max) {
                world.m_7731_(pos, newState, 3);
                if (!newState.m_60710_((LevelReader)world, pos)) {
                    world.m_186460_(pos, this.block.get(), 1);
                }
            } else {
                world.m_7731_(pos, newState, 2);
            }
            ForgeHooks.onCropsGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return this.type;
    }

    @Deprecated
    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return this.block.get().m_7898_(this.block.get().m_49966_(), world, pos);
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        return (Boolean)Config.bonemealBlockCrop.get();
    }

    public boolean m_214167_(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return (Boolean)Config.bonemealBlockCrop.get();
    }

    protected IPlantable getPlant() {
        Block block = this.block.get();
        if (block instanceof IPlantable) {
            IPlantable plantable = (IPlantable)block;
            return plantable;
        }
        return this;
    }
}

