/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common.datagen;

import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import knightminer.inspirations.building.InspirationsBuilding;
import knightminer.inspirations.building.block.RopeBlock;
import knightminer.inspirations.cauldrons.InspirationsCaudrons;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.tools.InspirationsTools;
import knightminer.inspirations.tweaks.InspirationsTweaks;
import knightminer.inspirations.utility.InspirationsUtility;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.loot.CanToolPerformAction;
import slimeknights.mantle.loot.function.RetexturedLootFunction;

public class InspirationsBlockLootTable
extends BlockLootSubProvider {
    private static final LootItemCondition.Builder HAS_SHEARS = CanToolPerformAction.canToolPerformAction((ToolAction)ToolActions.SHEARS_DIG);
    private static final LootItemCondition.Builder HAS_SHEARS_OR_SILK_TOUCH = HAS_SHEARS.m_285888_(f_243678_);

    protected InspirationsBlockLootTable() {
        super(Set.of(), FeatureFlags.f_244280_.m_247355_());
    }

    @Nonnull
    protected Iterable<Block> getKnownBlocks() {
        return BuiltInRegistries.f_256975_.m_6579_().stream().filter(entry -> {
            String ns = ((ResourceKey)entry.getKey()).m_135782_().m_135827_();
            return ns.equals("inspirations");
        }).map(Map.Entry::getValue).toList();
    }

    protected void m_245660_() {
        this.addBuilding();
        this.addRecipes();
        this.addTools();
        this.addTweaks();
        this.addUtility();
    }

    private void addBuilding() {
        InspirationsBuilding.shelf.values().forEach(block -> this.m_246481_((Block)block, this::droppingWithNameAndTexture));
        InspirationsBuilding.enlightenedBush.values().forEach(block -> this.m_246481_((Block)block, this::enlightenedBush));
        InspirationsBuilding.mulch.values().forEach(x$0 -> this.m_245724_((Block)x$0));
        InspirationsBuilding.path.values().forEach(x$0 -> this.m_245724_((Block)x$0));
        this.m_245644_(InspirationsBuilding.glassTrapdoor);
        this.m_247577_(InspirationsBuilding.glassDoor, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)InspirationsBuilding.glassDoor)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)InspirationsBuilding.glassDoor).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER))).m_79080_(f_243678_)));
        InspirationsBuilding.flower.values().forEach(x$0 -> this.m_245724_((Block)x$0));
        InspirationsBuilding.flowerPot.values().forEach(x$0 -> this.m_246535_((Block)x$0));
        this.m_246481_(InspirationsBuilding.rope, this::rope);
        this.m_246481_(InspirationsBuilding.vine, this::rope);
    }

    private void addRecipes() {
        this.m_246125_((Block)InspirationsCaudrons.beetrootSoupCauldron, (ItemLike)Blocks.f_50256_);
        this.m_246125_((Block)InspirationsCaudrons.mushroomStewCauldron, (ItemLike)Blocks.f_50256_);
        this.m_246125_((Block)InspirationsCaudrons.potatoSoupCauldron, (ItemLike)Blocks.f_50256_);
        this.m_246125_((Block)InspirationsCaudrons.rabbitStewCauldron, (ItemLike)Blocks.f_50256_);
        this.m_246125_((Block)InspirationsCaudrons.honeyCauldron, (ItemLike)Blocks.f_50256_);
        this.m_246125_((Block)InspirationsCaudrons.milkCauldron, (ItemLike)Blocks.f_50256_);
        this.m_246125_((Block)InspirationsCaudrons.dyeCauldron, (ItemLike)Blocks.f_50256_);
        this.m_246125_((Block)InspirationsCaudrons.potionCauldron, (ItemLike)Blocks.f_50256_);
        this.m_246125_((Block)InspirationsCaudrons.suspiciousStewCauldron, (ItemLike)Blocks.f_50256_);
    }

    private void addTools() {
        this.m_247577_(InspirationsTools.redstoneCharge, InspirationsBlockLootTable.m_246386_());
    }

    private void addTweaks() {
        if (Config.enableFittedCarpets.getAsBoolean()) {
            for (DyeColor color : DyeColor.values()) {
                this.registerRedirect((Block)InspirationsTweaks.fitCarpets.get((Enum)color), (Block)InspirationsTweaks.flatCarpets.get((Enum)color));
            }
        }
        this.m_247577_((Block)InspirationsTweaks.wetHopper, this.m_246180_((Block)InspirationsTweaks.dryHopper));
        this.m_246125_((Block)InspirationsTweaks.sugarCane, (ItemLike)InspirationsTweaks.sugarCaneSeeds);
        this.m_246125_((Block)InspirationsTweaks.cactus, (ItemLike)InspirationsTweaks.cactusSeeds);
    }

    private void addUtility() {
        InspirationsUtility.carpetedTrapdoors.values().forEach(x$0 -> this.m_245724_((Block)x$0));
        InspirationsUtility.carpetedPressurePlates.forEach((color, plate) -> this.m_247577_((Block)plate, LootTable.m_79147_().m_79161_((LootPool.Builder)this.m_247733_((ItemLike)plate, (ConditionUserBuilder)LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)plate.getCarpet())))).m_79161_((LootPool.Builder)this.m_247733_((ItemLike)plate, (ConditionUserBuilder)LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41967_))))));
        this.m_245724_(InspirationsUtility.pipe);
        this.m_245724_(InspirationsUtility.collector);
        this.m_246125_(InspirationsUtility.torchLeverFloor, (ItemLike)InspirationsUtility.torchLeverItem);
        this.m_246125_(InspirationsUtility.soulLeverFloor, (ItemLike)InspirationsUtility.soulLeverItem);
    }

    private LootTable.Builder rope(Block block) {
        RopeBlock rope = (RopeBlock)block;
        return LootTable.m_79147_().m_79161_((LootPool.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block)))).m_79161_((LootPool.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)rope.getRungsItem()).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)4.0f)))).m_79080_(LootItemBlockStatePropertyCondition.m_81769_((Block)rope).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(RopeBlock.RUNGS, (Comparable)((Object)RopeBlock.Rungs.NONE))).m_81807_())));
    }

    private LootTable.Builder enlightenedBush(Block bush) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)bush).m_79078_(RetexturedLootFunction::new)).m_79080_(HAS_SHEARS_OR_SILK_TOUCH));
    }

    private LootTable.Builder droppingWithNameAndTexture(Block block) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_(RetexturedLootFunction::new))));
    }

    private void registerRedirect(Block block, Block originalBlock) {
        this.m_247577_(block, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)originalBlock.m_60589_()))));
    }
}

